/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import java.lang.reflect.Method;
import org.junit.Assert;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EcmaError;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class WriteReadOnlyPropertyTest {
    @Test
    public void testWriteReadOnly_accepted() throws Exception {
        this.testWriteReadOnly(true);
    }

    @Test
    public void testWriteReadOnly_throws() throws Exception {
        try {
            this.testWriteReadOnly(false);
            Assert.fail();
        }
        catch (EcmaError e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Cannot set property myProp that has only a getter"));
        }
    }

    void testWriteReadOnly(final boolean acceptWriteReadOnly) throws Exception {
        Method readMethod = Foo.class.getMethod("getMyProp", null);
        final Foo foo = new Foo("hello");
        foo.defineProperty("myProp", null, readMethod, null, 0);
        String script = "foo.myProp = 123; foo.myProp";
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                ScriptableObject top = cx.initStandardObjects();
                ScriptableObject.putProperty((Scriptable)top, "foo", (Object)foo);
                cx.evaluateString(top, "foo.myProp = 123; foo.myProp", "script", 0, null);
                return null;
            }
        };
        ContextFactory contextFactory = new ContextFactory(){

            @Override
            protected boolean hasFeature(Context cx, int featureIndex) {
                if (11 == featureIndex) {
                    return !acceptWriteReadOnly;
                }
                return super.hasFeature(cx, featureIndex);
            }
        };
        contextFactory.call(action);
    }

    static class Foo
    extends ScriptableObject {
        final String prop_;

        Foo(String label) {
            this.prop_ = label;
        }

        @Override
        public String getClassName() {
            return "Foo";
        }

        public String getMyProp() {
            return this.prop_;
        }
    }
}

