/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ScriptableObject;

public class Utils {
    public static void runWithAllOptimizationLevels(ContextAction action) {
        Utils.runWithOptimizationLevel(action, -1);
        Utils.runWithOptimizationLevel(action, 0);
        Utils.runWithOptimizationLevel(action, 1);
    }

    public static void runWithAllOptimizationLevels(ContextFactory contextFactory, ContextAction action) {
        Utils.runWithOptimizationLevel(contextFactory, action, -1);
        Utils.runWithOptimizationLevel(contextFactory, action, 0);
        Utils.runWithOptimizationLevel(contextFactory, action, 1);
    }

    public static void runWithOptimizationLevel(ContextAction action, int optimizationLevel) {
        Utils.runWithOptimizationLevel(new ContextFactory(), action, optimizationLevel);
    }

    public static void runWithOptimizationLevel(ContextFactory contextFactory, ContextAction action, int optimizationLevel) {
        Context cx = contextFactory.enterContext();
        try {
            cx.setOptimizationLevel(optimizationLevel);
            action.run(cx);
        }
        finally {
            Context.exit();
        }
    }

    static void executeScript(final String script, int optimizationLevel) {
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                ScriptableObject scope = cx.initStandardObjects();
                return cx.evaluateString(scope, script, "myScript.js", 1, null);
            }
        };
        Utils.runWithOptimizationLevel(action, optimizationLevel);
    }
}

