/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.BaseFunction;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class TypeOfTest
extends TestCase {
    public void testCustomizeTypeOf() throws Exception {
        this.testCustomizeTypeOf("object", new Foo("object"));
        this.testCustomizeTypeOf("blabla", new Foo("blabla"));
    }

    public void test0() throws Exception {
        final BaseFunction f = new BaseFunction(){

            @Override
            public Object call(Context _cx, Scriptable _scope, Scriptable _thisObj, Object[] _args) {
                return _args[0].getClass().getName();
            }
        };
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context context) {
                ScriptableObject scope = context.initStandardObjects();
                scope.put("myObj", (Scriptable)scope, (Object)f);
                return context.evaluateString(scope, "typeof myObj", "test script", 1, null);
            }
        };
        this.doTest("function", action);
    }

    private void testCustomizeTypeOf(String expected, final Scriptable obj) {
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context context) {
                ScriptableObject scope = context.initStandardObjects();
                scope.put("myObj", (Scriptable)scope, (Object)obj);
                return context.evaluateString(scope, "typeof myObj", "test script", 1, null);
            }
        };
        this.doTest(expected, action);
    }

    public void testBug453360() throws Exception {
        this.doTest("object", "typeof new RegExp();");
        this.doTest("object", "typeof /foo/;");
    }

    private void doTest(String expected, final String script) {
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context context) {
                ScriptableObject scope = context.initStandardObjects();
                return context.evaluateString(scope, script, "test script", 1, null);
            }
        };
        this.doTest(expected, action);
    }

    private void doTest(String expected, ContextAction action) {
        this.doTest(-1, expected, action);
        this.doTest(0, expected, action);
        this.doTest(1, expected, action);
    }

    private void doTest(final int optimizationLevel, String expected, final ContextAction action) {
        Object o = new ContextFactory().call(new ContextAction(){

            @Override
            public Object run(Context context) {
                context.setOptimizationLevel(optimizationLevel);
                return Context.toString(action.run(context));
            }
        });
        TypeOfTest.assertEquals((Object)expected, (Object)o);
    }

    public static class Foo
    extends ScriptableObject {
        private static final long serialVersionUID = -8771045033217033529L;
        private final String typeOfValue_;

        public Foo(String _typeOfValue) {
            this.typeOfValue_ = _typeOfValue;
        }

        @Override
        public String getTypeOf() {
            return this.typeOfValue_;
        }

        @Override
        public String getClassName() {
            return "Foo";
        }
    }
}

