/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.ScriptableObject;

public class StrictModeApiTest
extends TestCase {
    private ScriptableObject global;
    private ContextFactory contextFactory;

    public void testStrictModeError() {
        this.contextFactory = new MyContextFactory();
        Context cx = this.contextFactory.enterContext();
        try {
            this.global = cx.initStandardObjects();
            try {
                this.runScript("({}.nonexistent);");
                StrictModeApiTest.fail();
            }
            catch (EvaluatorException e) {
                StrictModeApiTest.assertTrue((boolean)e.getMessage().startsWith("Reference to undefined property"));
            }
        }
        finally {
            Context.exit();
        }
    }

    private Object runScript(final String scriptSourceText) {
        return this.contextFactory.call(new ContextAction(){

            @Override
            public Object run(Context context) {
                return context.evaluateString(StrictModeApiTest.this.global, scriptSourceText, "test source", 1, null);
            }
        });
    }

    static class MyContextFactory
    extends ContextFactory {
        MyContextFactory() {
        }

        @Override
        protected boolean hasFeature(Context cx, int featureIndex) {
            switch (featureIndex) {
                case 8: 
                case 9: 
                case 11: 
                case 12: {
                    return true;
                }
            }
            return super.hasFeature(cx, featureIndex);
        }
    }
}

