/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.JavaScriptException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tests.Utils;

public class StackTraceTest
extends TestCase {
    static final String LS = System.getProperty("line.separator");

    public void testFailureStackTrace() {
        RhinoException.useMozillaStackStyle(false);
        String source1 = "function f2() { throw 'hello'; }; f2();";
        String source2 = "function f2() { 'H'.toLowerCase(); throw 'hello'; }; f2();";
        String source3 = "function f2() { new java.lang.String('H').toLowerCase(); throw 'hello'; }; f2();";
        String result = "\tat test.js (f2)" + LS + "\tat test.js" + LS;
        this.runWithExpectedStackTrace("function f2() { throw 'hello'; }; f2();", result);
        this.runWithExpectedStackTrace("function f2() { 'H'.toLowerCase(); throw 'hello'; }; f2();", result);
        this.runWithExpectedStackTrace("function f2() { new java.lang.String('H').toLowerCase(); throw 'hello'; }; f2();", result);
    }

    private void runWithExpectedStackTrace(final String _source, final String _expectedStackTrace) {
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                ScriptableObject scope = cx.initStandardObjects();
                try {
                    cx.evaluateString(scope, _source, "test.js", 0, null);
                }
                catch (JavaScriptException e) {
                    StackTraceTest.assertEquals((String)_expectedStackTrace, (String)e.getScriptStackTrace());
                    return null;
                }
                throw new RuntimeException("Exception expected!");
            }
        };
        Utils.runWithOptimizationLevel(action, -1);
    }
}

