/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tests.Utils;

public class PrimitiveTypeScopeResolutionTest {
    @Test
    public void functionCall() {
        String str2 = "function f() {\nString.prototype.foo = function() { return 'from 2' }; \nvar s2 = 's2';\nvar s2Foo = s2.foo();\nif (s2Foo != 'from 2') throw 's2 got: ' + s2Foo;\n}";
        String str1 = "String.prototype.foo = function() { return 'from 1'};scope2.f()";
        this.testWithTwoScopes(str1, str2);
    }

    @Test
    public void propertyAccess() {
        String str2 = "function f() { String.prototype.foo = 'from 2'; \nvar s2 = 's2';\nvar s2Foo = s2.foo;\nif (s2Foo != 'from 2') throw 's2 got: ' + s2Foo;\n}";
        String str1 = "String.prototype.foo = 'from 1'; scope2.f()";
        this.testWithTwoScopes(str1, str2);
    }

    @Test
    public void elementAccess() {
        String str2 = "function f() { String.prototype.foo = 'from 2'; \nvar s2 = 's2';\nvar s2Foo = s2['foo'];\nif (s2Foo != 'from 2') throw 's2 got: ' + s2Foo;\n}";
        String str1 = "String.prototype.foo = 'from 1'; scope2.f()";
        this.testWithTwoScopes(str1, str2);
    }

    private void testWithTwoScopes(final String scriptScope1, final String scriptScope2) {
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                Scriptable scope1 = cx.initStandardObjects(new MySimpleScriptableObject("scope1"));
                Scriptable scope2 = cx.initStandardObjects(new MySimpleScriptableObject("scope2"));
                cx.evaluateString(scope2, scriptScope2, "source2", 1, null);
                scope1.put("scope2", scope1, (Object)scope2);
                return cx.evaluateString(scope1, scriptScope1, "source1", 1, null);
            }
        };
        Utils.runWithAllOptimizationLevels(action);
    }

    @Test
    public void functionObjectPrimitiveToObject() throws Exception {
        String scriptScope2 = "function f() {\nString.prototype.foo = 'from 2'; \nvar s2 = 's2';\nvar s2Foo = s2.foo;\nvar s2FooReadByFunction = myObject.readPropFoo(s2);\nif (s2Foo != s2FooReadByFunction)\nthrow 's2 got: ' + s2FooReadByFunction;\n}";
        final MyObject myObject = new MyObject();
        String[] functionNames = new String[]{"readPropFoo"};
        myObject.defineFunctionProperties(functionNames, MyObject.class, 0);
        String scriptScope1 = "String.prototype.foo = 'from 1'; scope2.f()";
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                Scriptable scope1 = cx.initStandardObjects(new MySimpleScriptableObject("scope1"));
                Scriptable scope2 = cx.initStandardObjects(new MySimpleScriptableObject("scope2"));
                scope2.put("myObject", scope2, (Object)myObject);
                cx.evaluateString(scope2, "function f() {\nString.prototype.foo = 'from 2'; \nvar s2 = 's2';\nvar s2Foo = s2.foo;\nvar s2FooReadByFunction = myObject.readPropFoo(s2);\nif (s2Foo != s2FooReadByFunction)\nthrow 's2 got: ' + s2FooReadByFunction;\n}", "source2", 1, null);
                scope1.put("scope2", scope1, (Object)scope2);
                return cx.evaluateString(scope1, "String.prototype.foo = 'from 1'; scope2.f()", "source1", 1, null);
            }
        };
        Utils.runWithAllOptimizationLevels(action);
    }

    public static class MyObject
    extends ScriptableObject {
        private static final long serialVersionUID = 1L;

        @Override
        public String getClassName() {
            return "MyObject";
        }

        public Object readPropFoo(Scriptable s) {
            return ScriptableObject.getProperty(s, "foo");
        }
    }

    static class MySimpleScriptableObject
    extends ScriptableObject {
        private static final long serialVersionUID = 1L;
        private String label_;

        MySimpleScriptableObject(String label) {
            this.label_ = label;
        }

        @Override
        public String getClassName() {
            return "MySimpleScriptableObject";
        }

        public String toString() {
            return this.label_;
        }
    }
}

