/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import java.io.IOException;
import java.io.StringReader;
import java.util.List;
import junit.framework.TestCase;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Parser;
import org.mozilla.javascript.ast.Assignment;
import org.mozilla.javascript.ast.AstNode;
import org.mozilla.javascript.ast.AstRoot;
import org.mozilla.javascript.ast.Block;
import org.mozilla.javascript.ast.CatchClause;
import org.mozilla.javascript.ast.Comment;
import org.mozilla.javascript.ast.ConditionalExpression;
import org.mozilla.javascript.ast.ElementGet;
import org.mozilla.javascript.ast.ExpressionStatement;
import org.mozilla.javascript.ast.ForLoop;
import org.mozilla.javascript.ast.FunctionCall;
import org.mozilla.javascript.ast.FunctionNode;
import org.mozilla.javascript.ast.IfStatement;
import org.mozilla.javascript.ast.InfixExpression;
import org.mozilla.javascript.ast.LabeledStatement;
import org.mozilla.javascript.ast.Name;
import org.mozilla.javascript.ast.NumberLiteral;
import org.mozilla.javascript.ast.ObjectLiteral;
import org.mozilla.javascript.ast.ObjectProperty;
import org.mozilla.javascript.ast.ParenthesizedExpression;
import org.mozilla.javascript.ast.PropertyGet;
import org.mozilla.javascript.ast.RegExpLiteral;
import org.mozilla.javascript.ast.ReturnStatement;
import org.mozilla.javascript.ast.Scope;
import org.mozilla.javascript.ast.StringLiteral;
import org.mozilla.javascript.ast.SwitchCase;
import org.mozilla.javascript.ast.SwitchStatement;
import org.mozilla.javascript.ast.TryStatement;
import org.mozilla.javascript.ast.UnaryExpression;
import org.mozilla.javascript.ast.VariableDeclaration;
import org.mozilla.javascript.ast.VariableInitializer;
import org.mozilla.javascript.testing.TestErrorReporter;

public class ParserTest
extends TestCase {
    public void testAutoSemiColonBetweenNames() {
        AstRoot root = this.parse("\nx\ny\nz\n");
        AstNode first = ((ExpressionStatement)root.getFirstChild()).getExpression();
        ParserTest.assertEquals((String)"x", (String)first.getString());
        AstNode second = ((ExpressionStatement)root.getFirstChild().getNext()).getExpression();
        ParserTest.assertEquals((String)"y", (String)second.getString());
        AstNode third = ((ExpressionStatement)root.getFirstChild().getNext().getNext()).getExpression();
        ParserTest.assertEquals((String)"z", (String)third.getString());
    }

    public void testLinenoAssign() {
        AstRoot root = this.parse("\n\na = b");
        ExpressionStatement st = (ExpressionStatement)root.getFirstChild();
        AstNode n = st.getExpression();
        ParserTest.assertTrue((boolean)(n instanceof Assignment));
        ParserTest.assertEquals((int)90, (int)n.getType());
        ParserTest.assertEquals((int)2, (int)n.getLineno());
    }

    public void testLinenoCall() {
        AstRoot root = this.parse("\nfoo(123);");
        ExpressionStatement st = (ExpressionStatement)root.getFirstChild();
        AstNode n = st.getExpression();
        ParserTest.assertTrue((boolean)(n instanceof FunctionCall));
        ParserTest.assertEquals((int)38, (int)n.getType());
        ParserTest.assertEquals((int)1, (int)n.getLineno());
    }

    public void testLinenoGetProp() {
        AstRoot root = this.parse("\nfoo.bar");
        ExpressionStatement st = (ExpressionStatement)root.getFirstChild();
        AstNode n = st.getExpression();
        ParserTest.assertTrue((boolean)(n instanceof PropertyGet));
        ParserTest.assertEquals((int)33, (int)n.getType());
        ParserTest.assertEquals((int)1, (int)n.getLineno());
        PropertyGet getprop = (PropertyGet)n;
        AstNode m = getprop.getRight();
        ParserTest.assertTrue((boolean)(m instanceof Name));
        ParserTest.assertEquals((int)39, (int)m.getType());
        ParserTest.assertEquals((int)1, (int)m.getLineno());
    }

    public void testLinenoGetElem() {
        AstRoot root = this.parse("\nfoo[123]");
        ExpressionStatement st = (ExpressionStatement)root.getFirstChild();
        AstNode n = st.getExpression();
        ParserTest.assertTrue((boolean)(n instanceof ElementGet));
        ParserTest.assertEquals((int)36, (int)n.getType());
        ParserTest.assertEquals((int)1, (int)n.getLineno());
    }

    public void testLinenoComment() {
        AstRoot root = this.parse("\n/** a */");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((int)1, (int)root.getComments().first().getLineno());
    }

    public void testLinenoComment2() {
        AstRoot root = this.parse("\n/**\n\n a */");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((int)1, (int)root.getComments().first().getLineno());
    }

    public void testLinenoComment3() {
        AstRoot root = this.parse("\n  \n\n/**\n\n a */");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((int)3, (int)root.getComments().first().getLineno());
    }

    public void testLinenoComment4() {
        AstRoot root = this.parse("\n  \n\n  /**\n\n a */");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((int)3, (int)root.getComments().first().getLineno());
    }

    public void testLineComment5() {
        AstRoot root = this.parse("  /**\n* a.\n* b.\n* c.*/\n");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((int)0, (int)root.getComments().first().getLineno());
    }

    public void testLineComment6() {
        AstRoot root = this.parse("  \n/**\n* a.\n* b.\n* c.*/\n");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((int)1, (int)root.getComments().first().getLineno());
    }

    public void testLinenoComment7() {
        AstRoot root = this.parse("var x;\n/**\n\n a */");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((int)1, (int)root.getComments().first().getLineno());
    }

    public void testLinenoComment8() {
        AstRoot root = this.parse("\nvar x;/**\n\n a */");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((int)1, (int)root.getComments().first().getLineno());
    }

    public void testLinenoLiteral() {
        AstRoot root = this.parse("\nvar d =\n    \"foo\";\nvar e =\n    1;\nvar f = \n    1.2;\nvar g = \n    2e5;\nvar h = \n    'bar';\n");
        VariableDeclaration stmt1 = (VariableDeclaration)root.getFirstChild();
        List<VariableInitializer> vars1 = stmt1.getVariables();
        VariableInitializer firstVar = vars1.get(0);
        Name firstVarName = (Name)firstVar.getTarget();
        AstNode firstVarLiteral = firstVar.getInitializer();
        VariableDeclaration stmt2 = (VariableDeclaration)stmt1.getNext();
        List<VariableInitializer> vars2 = stmt2.getVariables();
        VariableInitializer secondVar = vars2.get(0);
        Name secondVarName = (Name)secondVar.getTarget();
        AstNode secondVarLiteral = secondVar.getInitializer();
        VariableDeclaration stmt3 = (VariableDeclaration)stmt2.getNext();
        List<VariableInitializer> vars3 = stmt3.getVariables();
        VariableInitializer thirdVar = vars3.get(0);
        Name thirdVarName = (Name)thirdVar.getTarget();
        AstNode thirdVarLiteral = thirdVar.getInitializer();
        VariableDeclaration stmt4 = (VariableDeclaration)stmt3.getNext();
        List<VariableInitializer> vars4 = stmt4.getVariables();
        VariableInitializer fourthVar = vars4.get(0);
        Name fourthVarName = (Name)fourthVar.getTarget();
        AstNode fourthVarLiteral = fourthVar.getInitializer();
        VariableDeclaration stmt5 = (VariableDeclaration)stmt4.getNext();
        List<VariableInitializer> vars5 = stmt5.getVariables();
        VariableInitializer fifthVar = vars5.get(0);
        Name fifthVarName = (Name)fifthVar.getTarget();
        AstNode fifthVarLiteral = fifthVar.getInitializer();
        ParserTest.assertEquals((int)2, (int)firstVarLiteral.getLineno());
        ParserTest.assertEquals((int)4, (int)secondVarLiteral.getLineno());
        ParserTest.assertEquals((int)6, (int)thirdVarLiteral.getLineno());
        ParserTest.assertEquals((int)8, (int)fourthVarLiteral.getLineno());
        ParserTest.assertEquals((int)10, (int)fifthVarLiteral.getLineno());
    }

    public void testLinenoSwitch() {
        AstRoot root = this.parse("\nswitch (a) {\n   case\n     1:\n     b++;\n   case 2:\n   default:\n     b--;\n  }\n");
        SwitchStatement switchStmt = (SwitchStatement)root.getFirstChild();
        AstNode switchVar = switchStmt.getExpression();
        List<SwitchCase> cases = switchStmt.getCases();
        SwitchCase firstCase = cases.get(0);
        AstNode caseArg = firstCase.getExpression();
        List<AstNode> caseBody = firstCase.getStatements();
        ExpressionStatement exprStmt = (ExpressionStatement)caseBody.get(0);
        UnaryExpression incrExpr = (UnaryExpression)exprStmt.getExpression();
        AstNode incrVar = incrExpr.getOperand();
        SwitchCase secondCase = cases.get(1);
        AstNode defaultCase = cases.get(2);
        AstNode returnStmt = (AstNode)switchStmt.getNext();
        ParserTest.assertEquals((int)1, (int)switchStmt.getLineno());
        ParserTest.assertEquals((int)1, (int)switchVar.getLineno());
        ParserTest.assertEquals((int)2, (int)firstCase.getLineno());
        ParserTest.assertEquals((int)3, (int)caseArg.getLineno());
        ParserTest.assertEquals((int)4, (int)exprStmt.getLineno());
        ParserTest.assertEquals((int)4, (int)incrExpr.getLineno());
        ParserTest.assertEquals((int)4, (int)incrVar.getLineno());
        ParserTest.assertEquals((int)5, (int)secondCase.getLineno());
        ParserTest.assertEquals((int)6, (int)defaultCase.getLineno());
    }

    public void testLinenoFunctionParams() {
        AstRoot root = this.parse("\nfunction\n    foo(\n    a,\n    b,\n    c) {\n}\n");
        FunctionNode function = (FunctionNode)root.getFirstChild();
        Name functionName = function.getFunctionName();
        AstNode body = function.getBody();
        List<AstNode> params = function.getParams();
        AstNode param1 = params.get(0);
        AstNode param2 = params.get(1);
        AstNode param3 = params.get(2);
        ParserTest.assertEquals((int)1, (int)function.getLineno());
        ParserTest.assertEquals((int)2, (int)functionName.getLineno());
        ParserTest.assertEquals((int)3, (int)param1.getLineno());
        ParserTest.assertEquals((int)4, (int)param2.getLineno());
        ParserTest.assertEquals((int)5, (int)param3.getLineno());
        ParserTest.assertEquals((int)5, (int)body.getLineno());
    }

    public void testLinenoVarDecl() {
        AstRoot root = this.parse("\nvar\n    a =\n    3\n");
        VariableDeclaration decl = (VariableDeclaration)root.getFirstChild();
        List<VariableInitializer> vars = decl.getVariables();
        VariableInitializer init = vars.get(0);
        AstNode declName = init.getTarget();
        AstNode expr = init.getInitializer();
        ParserTest.assertEquals((int)1, (int)decl.getLineno());
        ParserTest.assertEquals((int)2, (int)init.getLineno());
        ParserTest.assertEquals((int)2, (int)declName.getLineno());
        ParserTest.assertEquals((int)3, (int)expr.getLineno());
    }

    public void testLinenoReturn() {
        AstRoot root = this.parse("\nfunction\n    foo(\n    a,\n    b,\n    c) {\n    return\n    4;\n}\n");
        FunctionNode function = (FunctionNode)root.getFirstChild();
        Name functionName = function.getFunctionName();
        AstNode body = function.getBody();
        ReturnStatement returnStmt = (ReturnStatement)body.getFirstChild();
        ExpressionStatement exprStmt = (ExpressionStatement)returnStmt.getNext();
        AstNode returnVal = exprStmt.getExpression();
        ParserTest.assertEquals((int)6, (int)returnStmt.getLineno());
        ParserTest.assertEquals((int)7, (int)exprStmt.getLineno());
        ParserTest.assertEquals((int)7, (int)returnVal.getLineno());
    }

    public void testLinenoFor() {
        AstRoot root = this.parse("\nfor(\n;\n;\n) {\n}\n");
        ForLoop forLoop = (ForLoop)root.getFirstChild();
        AstNode initClause = forLoop.getInitializer();
        AstNode condClause = forLoop.getCondition();
        AstNode incrClause = forLoop.getIncrement();
        ParserTest.assertEquals((int)1, (int)forLoop.getLineno());
        ParserTest.assertEquals((int)2, (int)initClause.getLineno());
        ParserTest.assertEquals((int)3, (int)condClause.getLineno());
        ParserTest.assertEquals((int)4, (int)incrClause.getLineno());
    }

    public void testLinenoInfix() {
        AstRoot root = this.parse("\nvar d = a\n    + \n    b;\nvar\n    e =\n    a +\n    c;\nvar f = b\n    / c;\n");
        VariableDeclaration stmt1 = (VariableDeclaration)root.getFirstChild();
        List<VariableInitializer> vars1 = stmt1.getVariables();
        VariableInitializer var1 = vars1.get(0);
        Name firstVarName = (Name)var1.getTarget();
        InfixExpression var1Add = (InfixExpression)var1.getInitializer();
        VariableDeclaration stmt2 = (VariableDeclaration)stmt1.getNext();
        List<VariableInitializer> vars2 = stmt2.getVariables();
        VariableInitializer var2 = vars2.get(0);
        Name secondVarName = (Name)var2.getTarget();
        InfixExpression var2Add = (InfixExpression)var2.getInitializer();
        VariableDeclaration stmt3 = (VariableDeclaration)stmt2.getNext();
        List<VariableInitializer> vars3 = stmt3.getVariables();
        VariableInitializer var3 = vars3.get(0);
        Name thirdVarName = (Name)var3.getTarget();
        InfixExpression thirdVarDiv = (InfixExpression)var3.getInitializer();
        ReturnStatement returnStmt = (ReturnStatement)stmt3.getNext();
        ParserTest.assertEquals((int)1, (int)var1.getLineno());
        ParserTest.assertEquals((int)1, (int)firstVarName.getLineno());
        ParserTest.assertEquals((int)2, (int)var1Add.getLineno());
        ParserTest.assertEquals((int)1, (int)var1Add.getLeft().getLineno());
        ParserTest.assertEquals((int)3, (int)var1Add.getRight().getLineno());
        ParserTest.assertEquals((int)5, (int)var2.getLineno());
        ParserTest.assertEquals((int)5, (int)secondVarName.getLineno());
        ParserTest.assertEquals((int)6, (int)var2Add.getLineno());
        ParserTest.assertEquals((int)6, (int)var2Add.getLeft().getLineno());
        ParserTest.assertEquals((int)7, (int)var2Add.getRight().getLineno());
        ParserTest.assertEquals((int)8, (int)var3.getLineno());
        ParserTest.assertEquals((int)8, (int)thirdVarName.getLineno());
        ParserTest.assertEquals((int)9, (int)thirdVarDiv.getLineno());
        ParserTest.assertEquals((int)8, (int)thirdVarDiv.getLeft().getLineno());
        ParserTest.assertEquals((int)9, (int)thirdVarDiv.getRight().getLineno());
    }

    public void testLinenoPrefix() {
        AstRoot root = this.parse("\na++;\n   --\n   b;\n");
        ExpressionStatement first = (ExpressionStatement)root.getFirstChild();
        ExpressionStatement secondStmt = (ExpressionStatement)first.getNext();
        UnaryExpression firstOp = (UnaryExpression)first.getExpression();
        UnaryExpression secondOp = (UnaryExpression)secondStmt.getExpression();
        AstNode firstVarRef = firstOp.getOperand();
        AstNode secondVarRef = secondOp.getOperand();
        ParserTest.assertEquals((int)1, (int)firstOp.getLineno());
        ParserTest.assertEquals((int)2, (int)secondOp.getLineno());
        ParserTest.assertEquals((int)1, (int)firstVarRef.getLineno());
        ParserTest.assertEquals((int)3, (int)secondVarRef.getLineno());
    }

    public void testLinenoIf() {
        AstRoot root = this.parse("\nif\n   (a == 3)\n   {\n     b = 0;\n   }\n     else\n   {\n     c = 1;\n   }\n");
        IfStatement ifStmt = (IfStatement)root.getFirstChild();
        AstNode condClause = ifStmt.getCondition();
        AstNode thenClause = ifStmt.getThenPart();
        AstNode elseClause = ifStmt.getElsePart();
        ParserTest.assertEquals((int)1, (int)ifStmt.getLineno());
        ParserTest.assertEquals((int)2, (int)condClause.getLineno());
        ParserTest.assertEquals((int)3, (int)thenClause.getLineno());
        ParserTest.assertEquals((int)7, (int)elseClause.getLineno());
    }

    public void testLinenoTry() {
        AstRoot root = this.parse("\ntry {\n    var x = 1;\n} catch\n    (err)\n{\n} finally {\n    var y = 2;\n}\n");
        TryStatement tryStmt = (TryStatement)root.getFirstChild();
        AstNode tryBlock = tryStmt.getTryBlock();
        List<CatchClause> catchBlocks = tryStmt.getCatchClauses();
        CatchClause catchClause = catchBlocks.get(0);
        Block catchVarBlock = catchClause.getBody();
        Name catchVar = catchClause.getVarName();
        AstNode finallyBlock = tryStmt.getFinallyBlock();
        AstNode finallyStmt = (AstNode)finallyBlock.getFirstChild();
        ParserTest.assertEquals((int)1, (int)tryStmt.getLineno());
        ParserTest.assertEquals((int)1, (int)tryBlock.getLineno());
        ParserTest.assertEquals((int)5, (int)catchVarBlock.getLineno());
        ParserTest.assertEquals((int)4, (int)catchVar.getLineno());
        ParserTest.assertEquals((int)3, (int)catchClause.getLineno());
        ParserTest.assertEquals((int)6, (int)finallyBlock.getLineno());
        ParserTest.assertEquals((int)7, (int)finallyStmt.getLineno());
    }

    public void testLinenoConditional() {
        AstRoot root = this.parse("\na\n    ?\n    b\n    :\n    c\n    ;\n");
        ExpressionStatement ex = (ExpressionStatement)root.getFirstChild();
        ConditionalExpression hook = (ConditionalExpression)ex.getExpression();
        AstNode condExpr = hook.getTestExpression();
        AstNode thenExpr = hook.getTrueExpression();
        AstNode elseExpr = hook.getFalseExpression();
        ParserTest.assertEquals((int)2, (int)hook.getLineno());
        ParserTest.assertEquals((int)1, (int)condExpr.getLineno());
        ParserTest.assertEquals((int)3, (int)thenExpr.getLineno());
        ParserTest.assertEquals((int)5, (int)elseExpr.getLineno());
    }

    public void testLinenoLabel() {
        AstRoot root = this.parse("\nfoo:\na = 1;\nbar:\nb = 2;\n");
        LabeledStatement firstStmt = (LabeledStatement)root.getFirstChild();
        LabeledStatement secondStmt = (LabeledStatement)firstStmt.getNext();
        ParserTest.assertEquals((int)1, (int)firstStmt.getLineno());
        ParserTest.assertEquals((int)3, (int)secondStmt.getLineno());
    }

    public void testLinenoCompare() {
        AstRoot root = this.parse("\na\n<\nb\n");
        ExpressionStatement expr = (ExpressionStatement)root.getFirstChild();
        InfixExpression compare = (InfixExpression)expr.getExpression();
        AstNode lhs = compare.getLeft();
        AstNode rhs = compare.getRight();
        ParserTest.assertEquals((int)1, (int)lhs.getLineno());
        ParserTest.assertEquals((int)2, (int)compare.getLineno());
        ParserTest.assertEquals((int)3, (int)rhs.getLineno());
    }

    public void testLinenoEq() {
        AstRoot root = this.parse("\na\n==\nb\n");
        ExpressionStatement expr = (ExpressionStatement)root.getFirstChild();
        InfixExpression compare = (InfixExpression)expr.getExpression();
        AstNode lhs = compare.getLeft();
        AstNode rhs = compare.getRight();
        ParserTest.assertEquals((int)1, (int)lhs.getLineno());
        ParserTest.assertEquals((int)2, (int)compare.getLineno());
        ParserTest.assertEquals((int)3, (int)rhs.getLineno());
    }

    public void testLinenoPlusEq() {
        AstRoot root = this.parse("\na\n+=\nb\n");
        ExpressionStatement expr = (ExpressionStatement)root.getFirstChild();
        Assignment assign = (Assignment)expr.getExpression();
        AstNode lhs = assign.getLeft();
        AstNode rhs = assign.getRight();
        ParserTest.assertEquals((int)1, (int)lhs.getLineno());
        ParserTest.assertEquals((int)2, (int)assign.getLineno());
        ParserTest.assertEquals((int)3, (int)rhs.getLineno());
    }

    public void testLinenoComma() {
        AstRoot root = this.parse("\na,\n    b,\n    c;\n");
        ExpressionStatement stmt = (ExpressionStatement)root.getFirstChild();
        InfixExpression comma1 = (InfixExpression)stmt.getExpression();
        InfixExpression comma2 = (InfixExpression)comma1.getLeft();
        AstNode cRef = comma1.getRight();
        AstNode aRef = comma2.getLeft();
        AstNode bRef = comma2.getRight();
        ParserTest.assertEquals((int)2, (int)comma1.getLineno());
        ParserTest.assertEquals((int)1, (int)comma2.getLineno());
        ParserTest.assertEquals((int)1, (int)aRef.getLineno());
        ParserTest.assertEquals((int)2, (int)bRef.getLineno());
        ParserTest.assertEquals((int)3, (int)cRef.getLineno());
    }

    public void testRegexpLocation() {
        AstRoot root = this.parse("\nvar path =\n      replace(\n/a/g,'/');\n");
        VariableDeclaration firstVarDecl = (VariableDeclaration)root.getFirstChild();
        List<VariableInitializer> vars1 = firstVarDecl.getVariables();
        VariableInitializer firstInitializer = vars1.get(0);
        Name firstVarName = (Name)firstInitializer.getTarget();
        FunctionCall callNode = (FunctionCall)firstInitializer.getInitializer();
        AstNode fnName = callNode.getTarget();
        List<AstNode> args = callNode.getArguments();
        RegExpLiteral regexObject = (RegExpLiteral)args.get(0);
        AstNode aString = args.get(1);
        ParserTest.assertEquals((int)1, (int)firstVarDecl.getLineno());
        ParserTest.assertEquals((int)1, (int)firstVarName.getLineno());
        ParserTest.assertEquals((int)2, (int)callNode.getLineno());
        ParserTest.assertEquals((int)2, (int)fnName.getLineno());
        ParserTest.assertEquals((int)3, (int)regexObject.getLineno());
        ParserTest.assertEquals((int)3, (int)aString.getLineno());
    }

    public void testNestedOr() {
        AstRoot root = this.parse("\nif (a && \n    b() || \n    /* comment */\n    c) {\n}\n");
        IfStatement ifStmt = (IfStatement)root.getFirstChild();
        InfixExpression orClause = (InfixExpression)ifStmt.getCondition();
        InfixExpression andClause = (InfixExpression)orClause.getLeft();
        AstNode cName = orClause.getRight();
        ParserTest.assertEquals((int)1, (int)ifStmt.getLineno());
        ParserTest.assertEquals((int)2, (int)orClause.getLineno());
        ParserTest.assertEquals((int)1, (int)andClause.getLineno());
        ParserTest.assertEquals((int)4, (int)cName.getLineno());
    }

    public void testObjectLitLocation() {
        AstRoot root = this.parse("\nvar foo =\n{ \n'A' : 'A', \n'B' : 'B', \n'C' : \n      'C' \n};\n");
        VariableDeclaration firstVarDecl = (VariableDeclaration)root.getFirstChild();
        List<VariableInitializer> vars1 = firstVarDecl.getVariables();
        VariableInitializer firstInitializer = vars1.get(0);
        Name firstVarName = (Name)firstInitializer.getTarget();
        ObjectLiteral objectLiteral = (ObjectLiteral)firstInitializer.getInitializer();
        List<ObjectProperty> props = objectLiteral.getElements();
        ObjectProperty firstObjectLit = props.get(0);
        ObjectProperty secondObjectLit = props.get(1);
        ObjectProperty thirdObjectLit = props.get(2);
        AstNode firstKey = firstObjectLit.getLeft();
        AstNode firstValue = firstObjectLit.getRight();
        AstNode secondKey = secondObjectLit.getLeft();
        AstNode secondValue = secondObjectLit.getRight();
        AstNode thirdKey = thirdObjectLit.getLeft();
        AstNode thirdValue = thirdObjectLit.getRight();
        ParserTest.assertEquals((int)1, (int)firstVarName.getLineno());
        ParserTest.assertEquals((int)2, (int)firstObjectLit.getLineno());
        ParserTest.assertEquals((int)3, (int)firstKey.getLineno());
        ParserTest.assertEquals((int)3, (int)firstValue.getLineno());
        ParserTest.assertEquals((int)4, (int)secondKey.getLineno());
        ParserTest.assertEquals((int)4, (int)secondValue.getLineno());
        ParserTest.assertEquals((int)5, (int)thirdKey.getLineno());
        ParserTest.assertEquals((int)6, (int)thirdValue.getLineno());
    }

    public void testTryWithoutCatchLocation() {
        AstRoot root = this.parse("\ntry {\n  var x = 1;\n} finally {\n  var y = 2;\n}\n");
        TryStatement tryStmt = (TryStatement)root.getFirstChild();
        AstNode tryBlock = tryStmt.getTryBlock();
        List<CatchClause> catchBlocks = tryStmt.getCatchClauses();
        Scope finallyBlock = (Scope)tryStmt.getFinallyBlock();
        AstNode finallyStmt = (AstNode)finallyBlock.getFirstChild();
        ParserTest.assertEquals((int)1, (int)tryStmt.getLineno());
        ParserTest.assertEquals((int)1, (int)tryBlock.getLineno());
        ParserTest.assertEquals((int)3, (int)finallyBlock.getLineno());
        ParserTest.assertEquals((int)4, (int)finallyStmt.getLineno());
    }

    public void testTryWithoutFinallyLocation() {
        AstRoot root = this.parse("\ntry {\n  var x = 1;\n} catch (ex) {\n  var y = 2;\n}\n");
        TryStatement tryStmt = (TryStatement)root.getFirstChild();
        Scope tryBlock = (Scope)tryStmt.getTryBlock();
        List<CatchClause> catchBlocks = tryStmt.getCatchClauses();
        CatchClause catchClause = catchBlocks.get(0);
        Block catchStmt = catchClause.getBody();
        Name exceptionVar = catchClause.getVarName();
        AstNode varDecl = (AstNode)catchStmt.getFirstChild();
        ParserTest.assertEquals((int)1, (int)tryStmt.getLineno());
        ParserTest.assertEquals((int)1, (int)tryBlock.getLineno());
        ParserTest.assertEquals((int)3, (int)catchClause.getLineno());
        ParserTest.assertEquals((int)3, (int)catchStmt.getLineno());
        ParserTest.assertEquals((int)3, (int)exceptionVar.getLineno());
        ParserTest.assertEquals((int)4, (int)varDecl.getLineno());
    }

    public void testLinenoMultilineEq() {
        AstRoot root = this.parse("\nif\n    (((a == \n  3) && \n  (b == 2)) || \n (c == 1)) {\n}\n");
        IfStatement ifStmt = (IfStatement)root.getFirstChild();
        InfixExpression orTest = (InfixExpression)ifStmt.getCondition();
        ParenthesizedExpression cTestParen = (ParenthesizedExpression)orTest.getRight();
        InfixExpression cTest = (InfixExpression)cTestParen.getExpression();
        ParenthesizedExpression andTestParen = (ParenthesizedExpression)orTest.getLeft();
        InfixExpression andTest = (InfixExpression)andTestParen.getExpression();
        AstNode aTest = andTest.getLeft();
        AstNode bTest = andTest.getRight();
        ParserTest.assertEquals((int)1, (int)ifStmt.getLineno());
        ParserTest.assertEquals((int)4, (int)orTest.getLineno());
        ParserTest.assertEquals((int)3, (int)andTest.getLineno());
        ParserTest.assertEquals((int)2, (int)aTest.getLineno());
        ParserTest.assertEquals((int)4, (int)bTest.getLineno());
        ParserTest.assertEquals((int)5, (int)cTest.getLineno());
        ParserTest.assertEquals((int)5, (int)cTestParen.getLineno());
        ParserTest.assertEquals((int)2, (int)andTestParen.getLineno());
    }

    public void testLinenoMultilineBitTest() {
        AstRoot root = this.parse("\nif (\n      ((a \n        | 3 \n       ) == \n       (b \n        & 2)) && \n      ((a \n         ^ 0xffff) \n       != \n       (c \n        << 1))) {\n}\n");
        IfStatement ifStmt = (IfStatement)root.getFirstChild();
        InfixExpression andTest = (InfixExpression)ifStmt.getCondition();
        ParenthesizedExpression bigLHSExpr = (ParenthesizedExpression)andTest.getLeft();
        ParenthesizedExpression bigRHSExpr = (ParenthesizedExpression)andTest.getRight();
        InfixExpression eqTest = (InfixExpression)bigLHSExpr.getExpression();
        InfixExpression notEqTest = (InfixExpression)bigRHSExpr.getExpression();
        ParenthesizedExpression test1Expr = (ParenthesizedExpression)eqTest.getLeft();
        ParenthesizedExpression test2Expr = (ParenthesizedExpression)eqTest.getRight();
        ParenthesizedExpression test3Expr = (ParenthesizedExpression)notEqTest.getLeft();
        ParenthesizedExpression test4Expr = (ParenthesizedExpression)notEqTest.getRight();
        InfixExpression bitOrTest = (InfixExpression)test1Expr.getExpression();
        InfixExpression bitAndTest = (InfixExpression)test2Expr.getExpression();
        InfixExpression bitXorTest = (InfixExpression)test3Expr.getExpression();
        InfixExpression bitShiftTest = (InfixExpression)test4Expr.getExpression();
        ParserTest.assertEquals((int)1, (int)ifStmt.getLineno());
        ParserTest.assertEquals((int)2, (int)bigLHSExpr.getLineno());
        ParserTest.assertEquals((int)7, (int)bigRHSExpr.getLineno());
        ParserTest.assertEquals((int)4, (int)eqTest.getLineno());
        ParserTest.assertEquals((int)9, (int)notEqTest.getLineno());
        ParserTest.assertEquals((int)2, (int)test1Expr.getLineno());
        ParserTest.assertEquals((int)5, (int)test2Expr.getLineno());
        ParserTest.assertEquals((int)7, (int)test3Expr.getLineno());
        ParserTest.assertEquals((int)10, (int)test4Expr.getLineno());
        ParserTest.assertEquals((int)3, (int)bitOrTest.getLineno());
        ParserTest.assertEquals((int)6, (int)bitAndTest.getLineno());
        ParserTest.assertEquals((int)8, (int)bitXorTest.getLineno());
        ParserTest.assertEquals((int)11, (int)bitShiftTest.getLineno());
    }

    public void testLinenoFunctionCall() {
        AstRoot root = this.parse("\nfoo.\nbar.\nbaz(1);");
        ExpressionStatement stmt = (ExpressionStatement)root.getFirstChild();
        FunctionCall fc = (FunctionCall)stmt.getExpression();
        ParserTest.assertEquals((int)3, (int)fc.getLineno());
    }

    public void testLinenoName() {
        AstRoot root = this.parse("\na;\nb.\nc;\n");
        ExpressionStatement exprStmt = (ExpressionStatement)root.getFirstChild();
        AstNode aRef = exprStmt.getExpression();
        ExpressionStatement bExprStmt = (ExpressionStatement)exprStmt.getNext();
        AstNode bRef = bExprStmt.getExpression();
        ParserTest.assertEquals((int)1, (int)aRef.getLineno());
        ParserTest.assertEquals((int)2, (int)bRef.getLineno());
    }

    public void testLinenoDeclaration() {
        AstRoot root = this.parse("\na.\nb=\nfunction() {};\n");
        ExpressionStatement exprStmt = (ExpressionStatement)root.getFirstChild();
        Assignment fnAssignment = (Assignment)exprStmt.getExpression();
        PropertyGet aDotbName = (PropertyGet)fnAssignment.getLeft();
        AstNode aName = aDotbName.getLeft();
        AstNode bName = aDotbName.getRight();
        FunctionNode fnNode = (FunctionNode)fnAssignment.getRight();
        ParserTest.assertEquals((int)2, (int)fnAssignment.getLineno());
        ParserTest.assertEquals((int)1, (int)aDotbName.getLineno());
        ParserTest.assertEquals((int)1, (int)aName.getLineno());
        ParserTest.assertEquals((int)2, (int)bName.getLineno());
        ParserTest.assertEquals((int)3, (int)fnNode.getLineno());
    }

    public void testInOperatorInForLoop1() {
        this.parse("var a={};function b_(p){ return p;};for(var i=b_(\"length\" in a);i<0;) {}");
    }

    public void testInOperatorInForLoop2() {
        this.parse("var a={}; for (;(\"length\" in a);) {}");
    }

    public void testInOperatorInForLoop3() {
        this.parse("for (x in y) {}");
    }

    public void testJSDocAttachment1() {
        AstRoot root = this.parse("/** @type number */var a;");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((String)"/** @type number */", (String)root.getComments().first().getValue());
        ParserTest.assertNotNull((Object)root.getFirstChild().getJsDoc());
    }

    public void testJSDocAttachment2() {
        AstRoot root = this.parse("/** @type number */a.b;");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((String)"/** @type number */", (String)root.getComments().first().getValue());
        ExpressionStatement st = (ExpressionStatement)root.getFirstChild();
        ParserTest.assertNotNull((Object)st.getExpression().getJsDoc());
    }

    public void testJSDocAttachment3() {
        AstRoot root = this.parse("var a = /** @type number */(x);");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((String)"/** @type number */", (String)root.getComments().first().getValue());
        VariableDeclaration vd = (VariableDeclaration)root.getFirstChild();
        VariableInitializer vi = vd.getVariables().get(0);
        ParserTest.assertNotNull((Object)vi.getInitializer().getJsDoc());
    }

    public void testJSDocAttachment4() {
        AstRoot root = this.parse("(function() {/** should not be attached */})()");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ExpressionStatement st = (ExpressionStatement)root.getFirstChild();
        FunctionCall fc = (FunctionCall)st.getExpression();
        ParenthesizedExpression pe = (ParenthesizedExpression)fc.getTarget();
        ParserTest.assertNull((Object)pe.getJsDoc());
    }

    public void testJSDocAttachment5() {
        AstRoot root = this.parse("({/** attach me */ 1: 2});");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ExpressionStatement st = (ExpressionStatement)root.getFirstChild();
        ParenthesizedExpression pt = (ParenthesizedExpression)st.getExpression();
        ObjectLiteral lit = (ObjectLiteral)pt.getExpression();
        NumberLiteral number = (NumberLiteral)lit.getElements().get(0).getLeft();
        ParserTest.assertNotNull((Object)number.getJsDoc());
    }

    public void testJSDocAttachment6() {
        AstRoot root = this.parse("({1: /** don't attach me */ 2, 3: 4});");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ExpressionStatement st = (ExpressionStatement)root.getFirstChild();
        ParenthesizedExpression pt = (ParenthesizedExpression)st.getExpression();
        ObjectLiteral lit = (ObjectLiteral)pt.getExpression();
        for (ObjectProperty el : lit.getElements()) {
            ParserTest.assertNull((Object)el.getLeft().getJsDoc());
            ParserTest.assertNull((Object)el.getRight().getJsDoc());
        }
    }

    public void testJSDocAttachment7() {
        AstRoot root = this.parse("({/** attach me */ '1': 2});");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ExpressionStatement st = (ExpressionStatement)root.getFirstChild();
        ParenthesizedExpression pt = (ParenthesizedExpression)st.getExpression();
        ObjectLiteral lit = (ObjectLiteral)pt.getExpression();
        StringLiteral stringLit = (StringLiteral)lit.getElements().get(0).getLeft();
        ParserTest.assertNotNull((Object)stringLit.getJsDoc());
    }

    public void testJSDocAttachment8() {
        AstRoot root = this.parse("({'1': /** attach me */ (foo())});");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ExpressionStatement st = (ExpressionStatement)root.getFirstChild();
        ParenthesizedExpression pt = (ParenthesizedExpression)st.getExpression();
        ObjectLiteral lit = (ObjectLiteral)pt.getExpression();
        ParenthesizedExpression parens = (ParenthesizedExpression)lit.getElements().get(0).getRight();
        ParserTest.assertNotNull((Object)parens.getJsDoc());
    }

    public void testParsingWithoutJSDoc() {
        AstRoot root = this.parse("var a = /** @type number */(x);", false);
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)1, (int)root.getComments().size());
        ParserTest.assertEquals((String)"/** @type number */", (String)root.getComments().first().getValue());
        VariableDeclaration vd = (VariableDeclaration)root.getFirstChild();
        VariableInitializer vi = vd.getVariables().get(0);
        ParserTest.assertTrue((boolean)(vi.getInitializer() instanceof ParenthesizedExpression));
    }

    public void testParseCommentsAsReader() throws IOException {
        AstRoot root = this.parseAsReader("/** a */var a;\n /** b */var b; /** c */var c;");
        ParserTest.assertNotNull(root.getComments());
        ParserTest.assertEquals((int)3, (int)root.getComments().size());
        Comment[] comments = new Comment[3];
        comments = root.getComments().toArray(comments);
        ParserTest.assertEquals((String)"/** a */", (String)comments[0].getValue());
        ParserTest.assertEquals((String)"/** b */", (String)comments[1].getValue());
        ParserTest.assertEquals((String)"/** c */", (String)comments[2].getValue());
    }

    public void testParseCommentsAsReader2() throws IOException {
        String js = "";
        int i = 0;
        while (i < 100) {
            String stri = Integer.toString(i);
            js = String.valueOf(js) + "/** Some comment for a" + stri + " */" + "var a" + stri + " = " + stri + ";\n";
            ++i;
        }
        AstRoot root = this.parseAsReader(js);
    }

    private AstRoot parse(String string) {
        return this.parse(string, true);
    }

    private AstRoot parse(String string, boolean jsdoc) {
        CompilerEnvirons environment = new CompilerEnvirons();
        TestErrorReporter testErrorReporter = new TestErrorReporter(null, null);
        environment.setErrorReporter(testErrorReporter);
        environment.setRecordingComments(true);
        environment.setRecordingLocalJsDocComments(jsdoc);
        Parser p = new Parser(environment, testErrorReporter);
        AstRoot script = p.parse(string, null, 0);
        ParserTest.assertTrue((boolean)testErrorReporter.hasEncounteredAllErrors());
        ParserTest.assertTrue((boolean)testErrorReporter.hasEncounteredAllWarnings());
        return script;
    }

    private AstRoot parseAsReader(String string) throws IOException {
        CompilerEnvirons environment = new CompilerEnvirons();
        TestErrorReporter testErrorReporter = new TestErrorReporter(null, null);
        environment.setErrorReporter(testErrorReporter);
        environment.setRecordingComments(true);
        environment.setRecordingLocalJsDocComments(true);
        Parser p = new Parser(environment, testErrorReporter);
        AstRoot script = p.parse(new StringReader(string), null, 0);
        ParserTest.assertTrue((boolean)testErrorReporter.hasEncounteredAllErrors());
        ParserTest.assertTrue((boolean)testErrorReporter.hasEncounteredAllWarnings());
        return script;
    }
}

