/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.drivers.TestUtils;

public class ObserveInstructionCountTest
extends TestCase {
    protected void setUp() {
        TestUtils.setGlobalContextFactory(new MyFactory());
    }

    protected void tearDown() {
        TestUtils.setGlobalContextFactory(null);
    }

    private void baseCase(int optimizationLevel, String source) {
        MyFactory factory = new MyFactory();
        Context cx = factory.enterContext();
        cx.setOptimizationLevel(optimizationLevel);
        ObserveInstructionCountTest.assertTrue((boolean)(cx instanceof MyContext));
        try {
            try {
                ScriptableObject globalScope = cx.initStandardObjects();
                cx.evaluateString(globalScope, source, "test source", 1, null);
                ObserveInstructionCountTest.fail();
            }
            catch (QuotaExceeded globalScope) {
                Context.exit();
            }
            catch (RuntimeException e) {
                ObserveInstructionCountTest.fail((String)e.toString());
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public void testWhileTrueInGlobal() {
        String source = "var i=0; while (true) i++;";
        this.baseCase(-1, source);
        this.baseCase(1, source);
    }

    public void testWhileTrueNoCounterInGlobal() {
        String source = "while (true);";
        this.baseCase(-1, source);
        this.baseCase(1, source);
    }

    public void testWhileTrueInFunction() {
        String source = "var i=0; function f() { while (true) i++; } f();";
        this.baseCase(-1, source);
        this.baseCase(1, source);
    }

    public void testForever() {
        String source = "for(;;);";
        this.baseCase(-1, source);
        this.baseCase(1, source);
    }

    static class MyContext
    extends Context {
        int quota;

        MyContext(ContextFactory factory) {
            super(factory);
        }
    }

    static class MyFactory
    extends ContextFactory {
        MyFactory() {
        }

        @Override
        protected Context makeContext() {
            MyContext cx = new MyContext(this);
            cx.setInstructionObserverThreshold(500);
            return cx;
        }

        @Override
        protected void observeInstructionCount(Context cx, int instructionCount) {
            MyContext mcx = (MyContext)cx;
            mcx.quota -= instructionCount;
            if (mcx.quota <= 0) {
                throw new QuotaExceeded();
            }
        }

        @Override
        protected Object doTopCall(Callable callable, Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            MyContext mcx = (MyContext)cx;
            mcx.quota = 2000;
            return super.doTopCall(callable, cx, scope, thisObj, args);
        }
    }

    static class QuotaExceeded
    extends RuntimeException {
        private static final long serialVersionUID = -8018441873635071899L;

        QuotaExceeded() {
        }
    }
}

