/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.Scriptable;

public class NativeArrayTest {
    private NativeArray array;

    @Before
    public void init() {
        this.array = new NativeArray(1L);
    }

    @Test
    public void getIdsShouldIncludeBothIndexAndNormalProperties() {
        this.array.put(0, (Scriptable)this.array, (Object)"index");
        this.array.put("a", (Scriptable)this.array, (Object)"normal");
        Assert.assertThat((Object)this.array.getIds(), (Matcher)Is.is((Object)new Object[]{0, "a"}));
    }

    @Test
    public void deleteShouldRemoveIndexProperties() {
        this.array.put(0, (Scriptable)this.array, (Object)"a");
        this.array.delete(0);
        Assert.assertThat((Object)this.array.has(0, (Scriptable)this.array), (Matcher)Is.is((Object)false));
    }

    @Test
    public void deleteShouldRemoveNormalProperties() {
        this.array.put("p", (Scriptable)this.array, (Object)"a");
        this.array.delete("p");
        Assert.assertThat((Object)this.array.has("p", (Scriptable)this.array), (Matcher)Is.is((Object)false));
    }

    @Test
    public void putShouldAddIndexProperties() {
        this.array.put(0, (Scriptable)this.array, (Object)"a");
        Assert.assertThat((Object)this.array.has(0, (Scriptable)this.array), (Matcher)Is.is((Object)true));
    }

    @Test
    public void putShouldAddNormalProperties() {
        this.array.put("p", (Scriptable)this.array, (Object)"a");
        Assert.assertThat((Object)this.array.has("p", (Scriptable)this.array), (Matcher)Is.is((Object)true));
    }

    @Test
    public void getShouldReturnIndexProperties() {
        this.array.put(0, (Scriptable)this.array, (Object)"a");
        this.array.put("p", (Scriptable)this.array, (Object)"b");
        Assert.assertThat((Object)((String)this.array.get(0, (Scriptable)this.array)), (Matcher)Is.is((Object)"a"));
    }

    @Test
    public void getShouldReturnNormalProperties() {
        this.array.put("p", (Scriptable)this.array, (Object)"a");
        Assert.assertThat((Object)((String)this.array.get("p", (Scriptable)this.array)), (Matcher)Is.is((Object)"a"));
    }

    @Test
    public void hasShouldBeFalseForANewArray() {
        Assert.assertThat((Object)new NativeArray(0L).has(0, (Scriptable)this.array), (Matcher)Is.is((Object)false));
    }

    @Test
    public void getIndexIdsShouldBeEmptyForEmptyArray() {
        Assert.assertThat((Object)new NativeArray(0L).getIndexIds(), (Matcher)Is.is((Object)new Integer[0]));
    }

    @Test
    public void getIndexIdsShouldBeAZeroForSimpleSingletonArray() {
        this.array.put(0, (Scriptable)this.array, (Object)"a");
        Assert.assertThat((Object)this.array.getIndexIds(), (Matcher)Is.is((Object)new Integer[]{0}));
    }

    @Test
    public void getIndexIdsShouldWorkWhenIndicesSetAsString() {
        this.array.put("0", (Scriptable)this.array, (Object)"a");
        Assert.assertThat((Object)this.array.getIndexIds(), (Matcher)Is.is((Object)new Integer[]{0}));
    }

    @Test
    public void getIndexIdsShouldNotIncludeNegativeIds() {
        this.array.put(-1, (Scriptable)this.array, (Object)"a");
        Assert.assertThat((Object)this.array.getIndexIds(), (Matcher)Is.is((Object)new Integer[0]));
    }

    @Test
    public void getIndexIdsShouldIncludeIdsLessThan2ToThe32() {
        int maxIndex = Integer.MAX_VALUE;
        this.array.put(maxIndex, (Scriptable)this.array, (Object)"a");
        Assert.assertThat((Object)this.array.getIndexIds(), (Matcher)Is.is((Object)new Integer[]{maxIndex}));
    }

    @Test
    public void getIndexIdsShouldNotIncludeIdsGreaterThanOrEqualTo2ToThe32() {
        this.array.put("2147483648", (Scriptable)this.array, (Object)"a");
        Assert.assertThat((Object)this.array.getIndexIds(), (Matcher)Is.is((Object)new Integer[0]));
    }

    @Test
    public void getIndexIdsShouldNotReturnNonNumericIds() {
        this.array.put("x", (Scriptable)this.array, (Object)"a");
        Assert.assertThat((Object)this.array.getIndexIds(), (Matcher)Is.is((Object)new Integer[0]));
    }
}

