/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import junit.framework.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mozilla.javascript.drivers.ShellTest;
import org.mozilla.javascript.drivers.StandardTests;
import org.mozilla.javascript.drivers.TestUtils;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

@RunWith(value=Parameterized.class)
public class MozillaSuiteTest {
    private final File jsFile;
    private final int optimizationLevel;
    static final int[] OPT_LEVELS;

    static {
        int[] nArray = new int[3];
        nArray[0] = -1;
        nArray[2] = 9;
        OPT_LEVELS = nArray;
    }

    public MozillaSuiteTest(File jsFile, int optimizationLevel) {
        this.jsFile = jsFile;
        this.optimizationLevel = optimizationLevel;
    }

    public static File getTestDir() throws IOException {
        File testDir = null;
        if (System.getProperty("mozilla.js.tests") != null) {
            testDir = new File(System.getProperty("mozilla.js.tests"));
        } else {
            URL url = StandardTests.class.getResource(".");
            String path = url.getFile();
            int jsIndex = path.lastIndexOf("/js");
            if (jsIndex == -1) {
                throw new IllegalStateException("You aren't running the tests from within the standard mozilla/js directory structure");
            }
            path = path.substring(0, jsIndex + 3).replace('/', File.separatorChar);
            path = path.replace("%20", " ");
            testDir = new File(path, "tests");
        }
        if (!testDir.isDirectory()) {
            throw new FileNotFoundException(testDir + " is not a directory");
        }
        return testDir;
    }

    public static String getTestFilename(int optimizationLevel) {
        return "opt" + optimizationLevel + ".tests";
    }

    public static File[] getTestFiles(int optimizationLevel) throws IOException {
        File testDir = MozillaSuiteTest.getTestDir();
        Object[] tests = TestUtils.loadTestsFromResource("/" + MozillaSuiteTest.getTestFilename(optimizationLevel), null);
        Arrays.sort(tests);
        File[] files = new File[tests.length];
        int i = 0;
        while (i < files.length) {
            files[i] = new File(testDir, (String)tests[i]);
            ++i;
        }
        return files;
    }

    public static String loadFile(File f) throws IOException {
        int length = (int)f.length();
        char[] buf = new char[length];
        new FileReader(f).read(buf, 0, length);
        return new String(buf);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> mozillaSuiteValues() throws IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        int[] optLevels = OPT_LEVELS;
        int i = 0;
        while (i < optLevels.length) {
            File[] tests;
            File[] fileArray = tests = MozillaSuiteTest.getTestFiles(optLevels[i]);
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                result.add(new Object[]{f, optLevels[i]});
                ++n2;
            }
            ++i;
        }
        return result;
    }

    public static Collection<Object[]> singleDoctest() throws IOException {
        String SINGLE_TEST_FILE = "e4x/Expressions/11.1.1.js";
        int SINGLE_TEST_OPTIMIZATION_LEVEL = -1;
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        File f = new File(MozillaSuiteTest.getTestDir(), "e4x/Expressions/11.1.1.js");
        result.add(new Object[]{f, -1});
        return result;
    }

    @Test
    public void runMozillaTest() throws Exception {
        ShellContextFactory shellContextFactory = new ShellContextFactory();
        shellContextFactory.setOptimizationLevel(this.optimizationLevel);
        ShellTestParameters params = new ShellTestParameters();
        JunitStatus status = new JunitStatus();
        ShellTest.run(shellContextFactory, this.jsFile, params, status);
    }

    public static void main(String[] args) throws IOException {
        PrintStream out = new PrintStream("fix-tests-files.sh");
        try {
            int i = 0;
            while (i < OPT_LEVELS.length) {
                int optLevel = OPT_LEVELS[i];
                File testDir = MozillaSuiteTest.getTestDir();
                File[] allTests = TestUtils.recursiveListFiles(testDir, new FileFilter(){

                    @Override
                    public boolean accept(File pathname) {
                        return ShellTest.DIRECTORY_FILTER.accept(pathname) || ShellTest.TEST_FILTER.accept(pathname);
                    }
                });
                HashSet<File> diff = new HashSet<File>(Arrays.asList(allTests));
                File[] testFiles = MozillaSuiteTest.getTestFiles(optLevel);
                diff.removeAll(Arrays.asList(testFiles));
                ArrayList<String> skippedPassed = new ArrayList<String>();
                int absolutePathLength = testDir.getAbsolutePath().length() + 1;
                for (File testFile : diff) {
                    try {
                        new MozillaSuiteTest(testFile, optLevel).runMozillaTest();
                        String canonicalized = testFile.getAbsolutePath().substring(absolutePathLength);
                        canonicalized = canonicalized.replace('\\', '/');
                        skippedPassed.add(canonicalized);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
                if (skippedPassed.size() > 0) {
                    out.println("cat >> " + MozillaSuiteTest.getTestFilename(optLevel) + " <<EOF");
                    Object[] sorted = skippedPassed.toArray(new String[0]);
                    Arrays.sort(sorted);
                    int j = 0;
                    while (j < sorted.length) {
                        out.println((String)sorted[j]);
                        ++j;
                    }
                    out.println("EOF");
                }
                ++i;
            }
            System.out.println("Done.");
        }
        finally {
            out.close();
        }
    }

    private static class JunitStatus
    extends ShellTest.Status {
        File file;

        private JunitStatus() {
        }

        @Override
        public final void running(File jsFile) {
            this.file = jsFile;
        }

        @Override
        public final void failed(String s) {
            String msg = "In \"" + this.file + "\":" + System.getProperty("line.separator") + s;
            System.out.println(msg);
            Assert.fail((String)msg);
        }

        @Override
        public final void exitCodesWere(int expected, int actual) {
            Assert.assertEquals((String)"Unexpected exit code", (int)expected, (int)actual);
        }

        @Override
        public final void outputWas(String s) {
        }

        @Override
        public final void threw(Throwable t) {
            Assert.fail((String)ShellTest.getStackTrace(t));
        }

        @Override
        public final void timedOut() {
            this.failed("Timed out.");
        }
    }

    private static class ShellTestParameters
    extends ShellTest.Parameters {
        private ShellTestParameters() {
        }

        @Override
        public int getTimeoutMilliseconds() {
            if (System.getProperty("mozilla.js.tests.timeout") != null) {
                return Integer.parseInt(System.getProperty("mozilla.js.tests.timeout"));
            }
            return 10000;
        }
    }
}

