/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.drivers.TestUtils;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

public class JavaAcessibilityTest
extends TestCase {
    protected final Global global = new Global();
    String importClass = "importClass(Packages.org.mozilla.javascript.tests.PrivateAccessClass)\n";
    private ContextFactory contextFactory = new ShellContextFactory(){

        @Override
        protected boolean hasFeature(Context cx, int featureIndex) {
            if (featureIndex == 13) {
                return true;
            }
            return super.hasFeature(cx, featureIndex);
        }
    };

    public JavaAcessibilityTest() {
        this.global.init(this.contextFactory);
    }

    protected void setUp() {
        TestUtils.setGlobalContextFactory(this.contextFactory);
    }

    protected void tearDown() {
        TestUtils.setGlobalContextFactory(null);
    }

    public void testAccessingFields() {
        Object result = this.runScript(String.valueOf(this.importClass) + "PrivateAccessClass.staticPackagePrivateInt");
        JavaAcessibilityTest.assertEquals((Object)new Integer(0), (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "PrivateAccessClass.staticPrivateInt");
        JavaAcessibilityTest.assertEquals((Object)new Integer(1), (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "PrivateAccessClass.staticProtectedInt");
        JavaAcessibilityTest.assertEquals((Object)new Integer(2), (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass().packagePrivateString");
        JavaAcessibilityTest.assertEquals((Object)"package private", (Object)((NativeJavaObject)result).unwrap());
        result = this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass().privateString");
        JavaAcessibilityTest.assertEquals((Object)"private", (Object)((NativeJavaObject)result).unwrap());
        result = this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass().protectedString");
        JavaAcessibilityTest.assertEquals((Object)"protected", (Object)((NativeJavaObject)result).unwrap());
        result = this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass.PrivateNestedClass().packagePrivateInt");
        JavaAcessibilityTest.assertEquals((Object)new Integer(0), (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass.PrivateNestedClass().privateInt");
        JavaAcessibilityTest.assertEquals((Object)new Integer(1), (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass.PrivateNestedClass().protectedInt");
        JavaAcessibilityTest.assertEquals((Object)new Integer(2), (Object)result);
    }

    public void testAccessingMethods() {
        Object result = this.runScript(String.valueOf(this.importClass) + "PrivateAccessClass.staticPackagePrivateMethod()");
        JavaAcessibilityTest.assertEquals((Object)new Integer(0), (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "PrivateAccessClass.staticPrivateMethod()");
        JavaAcessibilityTest.assertEquals((Object)new Integer(1), (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "PrivateAccessClass.staticProtectedMethod()");
        JavaAcessibilityTest.assertEquals((Object)new Integer(2), (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass().packagePrivateMethod()");
        JavaAcessibilityTest.assertEquals((Object)new Integer(3), (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass().privateMethod()");
        JavaAcessibilityTest.assertEquals((Object)new Integer(4), (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass().protectedMethod()");
        JavaAcessibilityTest.assertEquals((Object)new Integer(5), (Object)result);
    }

    public void testAccessingConstructors() {
        this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass(\"foo\")");
        this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass(5)");
        this.runScript(String.valueOf(this.importClass) + "new PrivateAccessClass(5, \"foo\")");
    }

    public void testAccessingJavaBeanProperty() {
        Object result = this.runScript(String.valueOf(this.importClass) + "var x = new PrivateAccessClass(); x.javaBeanProperty + ' ' + x.getterCalled;");
        JavaAcessibilityTest.assertEquals((Object)"6 true", (Object)result);
        result = this.runScript(String.valueOf(this.importClass) + "var x = new PrivateAccessClass(); x.javaBeanProperty = 4; x.javaBeanProperty + ' ' + x.setterCalled;");
        JavaAcessibilityTest.assertEquals((Object)"4 true", (Object)result);
    }

    public void testOverloadFunctionRegression() {
        Object result = this.runScript("(new java.util.GregorianCalendar()).set(3,4);'success';");
        JavaAcessibilityTest.assertEquals((Object)"success", (Object)result);
    }

    private Object runScript(final String scriptSourceText) {
        return this.contextFactory.call(new ContextAction(){

            @Override
            public Object run(Context context) {
                Script script = context.compileString(scriptSourceText, "", 1, null);
                return script.exec(context, JavaAcessibilityTest.this.global);
            }
        });
    }
}

