/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tests.Utils;

public class GlobalParseXTest
extends TestCase {
    public void testParseFloatAndIntWhiteSpaces() {
        this.testParseFloatWhiteSpaces("\\u00A0 ");
        this.testParseFloatWhiteSpaces("\\t ");
        this.testParseFloatWhiteSpaces("\\u00A0 ");
        this.testParseFloatWhiteSpaces("\\u000C ");
        this.testParseFloatWhiteSpaces("\\u000B ");
        this.testParseFloatWhiteSpaces("\\u000D ");
        this.testParseFloatWhiteSpaces("\\u000A ");
        this.testParseFloatWhiteSpaces("\\u2028 ");
        this.testParseFloatWhiteSpaces("\\u2029 ");
    }

    private void testParseFloatWhiteSpaces(String prefix) {
        this.assertEvaluates("789", "String(parseInt('" + prefix + "789 '))");
        this.assertEvaluates("7.89", "String(parseFloat('" + prefix + "7.89 '))");
    }

    public void testParseFloatTrailingNoise() {
        this.testParseFloat("7890", "789e1");
        this.testParseFloat("7890", "789E1");
        this.testParseFloat("7890", "789E+1");
        this.testParseFloat("7890", "789E+1e");
        this.testParseFloat("789", "7890E-1");
        this.testParseFloat("789", "7890E-1e");
        this.testParseFloat("789", "789hello");
        this.testParseFloat("789", "789e");
        this.testParseFloat("789", "789E");
        this.testParseFloat("789", "789e+");
        this.testParseFloat("789", "789Efgh");
        this.testParseFloat("789", "789efgh");
        this.testParseFloat("789", "789e-");
        this.testParseFloat("789", "789e-hello");
        this.testParseFloat("789", "789e+hello");
        this.testParseFloat("789", "789+++hello");
        this.testParseFloat("789", "789-e-+hello");
        this.testParseFloat("789", "789e+e++hello");
        this.testParseFloat("789", "789e-e++hello");
    }

    private void testParseFloat(String expected, String value) {
        this.assertEvaluates(expected, "String(parseFloat('" + value + "'))");
    }

    private void assertEvaluates(final Object expected, final String source) {
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                ScriptableObject scope = cx.initStandardObjects();
                Object rep = cx.evaluateString(scope, source, "test.js", 0, null);
                GlobalParseXTest.assertEquals((Object)expected, (Object)rep);
                return null;
            }
        };
        Utils.runWithAllOptimizationLevels(action);
    }
}

