/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class GeneratedMethodNameTest
extends TestCase {
    public void testStandardFunction() throws Exception {
        String scriptCode = "function myFunc() {\n var m = javaNameGetter.readCurrentFunctionJavaName();\n  if (m != 'myFunc') throw 'got '  + m;}\nmyFunc();";
        this.doTest("function myFunc() {\n var m = javaNameGetter.readCurrentFunctionJavaName();\n  if (m != 'myFunc') throw 'got '  + m;}\nmyFunc();");
    }

    public void testFunctionDollar() throws Exception {
        String scriptCode = "function $() {\n var m = javaNameGetter.readCurrentFunctionJavaName();\n  if (m != '$') throw 'got '  + m;}\n$();";
        this.doTest("function $() {\n var m = javaNameGetter.readCurrentFunctionJavaName();\n  if (m != '$') throw 'got '  + m;}\n$();");
    }

    public void testScriptName() throws Exception {
        String scriptCode = "var m = javaNameGetter.readCurrentFunctionJavaName();\nif (m != 'script') throw 'got '  + m;";
        this.doTest("var m = javaNameGetter.readCurrentFunctionJavaName();\nif (m != 'script') throw 'got '  + m;");
    }

    public void testConstructor() throws Exception {
        String scriptCode = "function myFunc() {\n var m = javaNameGetter.readCurrentFunctionJavaName();\n  if (m != 'myFunc') throw 'got '  + m;}\nnew myFunc();";
        this.doTest("function myFunc() {\n var m = javaNameGetter.readCurrentFunctionJavaName();\n  if (m != 'myFunc') throw 'got '  + m;}\nnew myFunc();");
    }

    public void testAnonymousFunction() throws Exception {
        String scriptCode = "var myFunc = function() {\n var m = javaNameGetter.readCurrentFunctionJavaName();\n  if (m != 'anonymous') throw 'got '  + m;}\nmyFunc();";
        this.doTest("var myFunc = function() {\n var m = javaNameGetter.readCurrentFunctionJavaName();\n  if (m != 'anonymous') throw 'got '  + m;}\nmyFunc();");
    }

    public void doTest(String scriptCode) throws Exception {
        Context cx = ContextFactory.getGlobal().enterContext();
        try {
            ScriptableObject topScope = cx.initStandardObjects();
            topScope.put("javaNameGetter", (Scriptable)topScope, (Object)new JavaNameGetter());
            Script script = cx.compileString(scriptCode, "myScript", 1, null);
            script.exec(cx, topScope);
        }
        finally {
            Context.exit();
        }
    }

    public class JavaNameGetter {
        public String readCurrentFunctionJavaName() {
            RuntimeException t = new RuntimeException();
            return t.getStackTrace()[8].getMethodName().replaceFirst("_[^_]*_(.*)_[^_]*", "$1");
        }
    }
}

