/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;

public class GeneratedClassNameTest
extends TestCase {
    public void testGeneratedClassName() throws Exception {
        this.doTest("myScript_js", "myScript.js");
        this.doTest("foo", "foo");
        this.doTest("c", "");
        this.doTest("_1", "1");
        this.doTest("_", "_");
        this.doTest("unnamed_script", null);
        this.doTest("some_dir_some_foo_js", "some/dir/some/foo.js");
        this.doTest("some_dir_some_foo_js", "some\\dir\\some\\foo.js");
        this.doTest("_12_foo_34_js", "12 foo 34.js");
    }

    private void doTest(String expectedName, final String scriptName) throws Exception {
        Script script = (Script)ContextFactory.getGlobal().call(new ContextAction(){

            @Override
            public Object run(Context context) {
                return context.compileString("var f = 1", scriptName, 1, null);
            }
        });
        String name = script.getClass().getSimpleName();
        GeneratedClassNameTest.assertEquals((String)expectedName, (String)name.substring(0, name.lastIndexOf(95)));
    }
}

