/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import java.util.Collections;
import java.util.Map;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Evaluator {
    public static Object eval(String source) {
        return Evaluator.eval(source, null);
    }

    public static Object eval(String source, String id, Scriptable object) {
        return Evaluator.eval(source, Collections.singletonMap(id, object));
    }

    public static Object eval(String source, Map<String, Scriptable> bindings) {
        Context cx = ContextFactory.getGlobal().enterContext();
        try {
            ScriptableObject scope = cx.initStandardObjects();
            if (bindings != null) {
                for (Map.Entry<String, Scriptable> entry : bindings.entrySet()) {
                    Scriptable object = entry.getValue();
                    object.setParentScope(scope);
                    scope.put(entry.getKey(), (Scriptable)scope, (Object)object);
                }
            }
            Object object = cx.evaluateString(scope, source, "source", 1, null);
            return object;
        }
        finally {
            Context.exit();
        }
    }
}

