/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import org.junit.Assert;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.tests.Utils;

public class ErrorPropertiesTest {
    static final String LS = System.getProperty("line.separator");

    private void testScriptStackTrace(String script, String expectedStackTrace) {
        this.testScriptStackTrace(script, expectedStackTrace, -1);
        this.testScriptStackTrace(script, expectedStackTrace, 0);
        this.testScriptStackTrace(script, expectedStackTrace, 1);
    }

    private void testScriptStackTrace(String script, String expectedStackTrace, int optimizationLevel) {
        try {
            Utils.executeScript(script, optimizationLevel);
        }
        catch (RhinoException e) {
            Assert.assertEquals((Object)expectedStackTrace, (Object)e.getScriptStackTrace());
        }
    }

    @Test
    public void fileName() {
        this.testIt("try { null.method() } catch (e) { e.fileName }", "myScript.js");
        this.testIt("try { null.property } catch (e) { e.fileName }", "myScript.js");
    }

    @Test
    public void lineNumber() {
        this.testIt("try { null.method() } catch (e) { e.lineNumber }", 1);
        this.testIt("try {\n null.method() \n} catch (e) { e.lineNumber }", 2);
        this.testIt("\ntry \n{\n null.method() \n} catch (e) { e.lineNumber }", 4);
        this.testIt("function f() {\n null.method(); \n}\n try { f() } catch (e) { e.lineNumber }", 2);
    }

    @Test
    public void defaultStack() {
        RhinoException.useMozillaStackStyle(false);
        this.testScriptStackTrace("null.method()", "\tat myScript.js:1" + LS);
        String script = "function f() \n{\n  null.method();\n}\nf();\n";
        this.testScriptStackTrace("function f() \n{\n  null.method();\n}\nf();\n", "\tat myScript.js:3 (f)" + LS + "\tat myScript.js:5" + LS);
        this.testIt("try { null.method() } catch (e) { e.stack }", "\tat myScript.js:1" + LS);
        String expectedStack = "\tat myScript.js:2 (f)" + LS + "\tat myScript.js:4" + LS;
        this.testIt("function f() {\n null.method(); \n}\n try { f() } catch (e) { e.stack }", expectedStack);
    }

    @Test
    public void mozillaStack() {
        RhinoException.useMozillaStackStyle(true);
        this.testScriptStackTrace("null.method()", "@myScript.js:1" + LS);
        String script = "function f() \n{\n  null.method();\n}\nf();\n";
        this.testScriptStackTrace("function f() \n{\n  null.method();\n}\nf();\n", "f()@myScript.js:3" + LS + "@myScript.js:5" + LS);
        this.testIt("try { null.method() } catch (e) { e.stack }", "@myScript.js:1" + LS);
        String expectedStack = "f()@myScript.js:2" + LS + "@myScript.js:4" + LS;
        this.testIt("function f() {\n null.method(); \n}\n try { f() } catch (e) { e.stack }", expectedStack);
    }

    private void testIt(final String script, final Object expected) {
        ContextAction action = new ContextAction(){

            @Override
            public Object run(Context cx) {
                try {
                    ScriptableObject scope = cx.initStandardObjects();
                    Object o = cx.evaluateString(scope, script, "myScript.js", 1, null);
                    Assert.assertEquals((Object)expected, (Object)o);
                    return o;
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        Utils.runWithAllOptimizationLevels(action);
    }
}

