/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.drivers.TestUtils;
import org.mozilla.javascript.tools.shell.Global;

@RunWith(value=Parameterized.class)
public class DoctestsTest {
    static final String baseDirectory = "testsrc" + File.separator + "doctests";
    static final String doctestsExtension = ".doctest";
    String name;
    String source;
    int optimizationLevel;

    public DoctestsTest(String name, String source, int optimizationLevel) {
        this.name = name;
        this.source = source;
        this.optimizationLevel = optimizationLevel;
    }

    public static File[] getDoctestFiles() {
        return TestUtils.recursiveListFiles(new File(baseDirectory), new FileFilter(){

            @Override
            public boolean accept(File f) {
                return f.getName().endsWith(DoctestsTest.doctestsExtension);
            }
        });
    }

    public static String loadFile(File f) throws IOException {
        int length = (int)f.length();
        char[] buf = new char[length];
        new FileReader(f).read(buf, 0, length);
        return new String(buf);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> doctestValues() throws IOException {
        File[] doctests = DoctestsTest.getDoctestFiles();
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        File[] fileArray = doctests;
        int n = doctests.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            String contents = DoctestsTest.loadFile(f);
            result.add(new Object[]{f.getName(), contents, -1});
            result.add(new Object[]{f.getName(), contents, 0});
            result.add(new Object[]{f.getName(), contents, 9});
            ++n2;
        }
        return result;
    }

    public static Collection<Object[]> singleDoctest() throws IOException {
        ArrayList<Object[]> result = new ArrayList<Object[]>();
        File f = new File(baseDirectory, "Counter.doctest");
        String contents = DoctestsTest.loadFile(f);
        result.add(new Object[]{f.getName(), contents, -1});
        return result;
    }

    @Test
    public void runDoctest() throws Exception {
        ContextFactory factory = ContextFactory.getGlobal();
        Context cx = factory.enterContext();
        try {
            try {
                cx.setOptimizationLevel(this.optimizationLevel);
                Global global = new Global(cx);
                int testsPassed = global.runDoctest(cx, global, this.source, this.name, 1);
                System.out.println(String.valueOf(this.name) + "(" + this.optimizationLevel + "): " + testsPassed + " passed.");
                Assert.assertTrue((testsPassed > 0 ? 1 : 0) != 0);
            }
            catch (Exception ex) {
                System.out.println(String.valueOf(this.name) + "(" + this.optimizationLevel + "): FAILED due to " + ex);
                throw ex;
            }
        }
        finally {
            Context.exit();
        }
    }
}

