/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class DefineFunctionPropertiesTest
extends TestCase {
    ScriptableObject global;
    static Object key = "DefineFunctionPropertiesTest";

    public void setUp() {
        Context cx = Context.enter();
        try {
            this.global = cx.initStandardObjects();
            String[] names = new String[]{"f", "g"};
            this.global.defineFunctionProperties(names, DefineFunctionPropertiesTest.class, 2);
        }
        finally {
            Context.exit();
        }
    }

    public static int f(int a) {
        return a * 2;
    }

    public void testSimpleFunction() {
        Context cx = Context.enter();
        try {
            Object result = cx.evaluateString(this.global, "f(7) + 1", "test source", 1, null);
            DefineFunctionPropertiesTest.assertEquals((Object)15.0, (Object)result);
        }
        finally {
            Context.exit();
        }
    }

    public static Object g(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Object arg = args.length > 0 ? args[0] : Undefined.instance;
        Object privateValue = Undefined.instance;
        if (thisObj instanceof ScriptableObject) {
            privateValue = ((ScriptableObject)thisObj).getAssociatedValue(key);
        }
        return String.valueOf(arg.toString()) + privateValue;
    }

    public void testPrivateData() {
        Context cx = Context.enter();
        try {
            this.global.associateValue(key, "bar");
            Object result = cx.evaluateString(this.global, "g('foo');", "test source", 1, null);
            DefineFunctionPropertiesTest.assertEquals((Object)"foobar", (Object)result);
        }
        finally {
            Context.exit();
        }
    }
}

