/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.annotations.JSConstructor;
import org.mozilla.javascript.annotations.JSFunction;
import org.mozilla.javascript.annotations.JSGetter;
import org.mozilla.javascript.annotations.JSSetter;
import org.mozilla.javascript.annotations.JSStaticFunction;

public class DefineClassTest {
    Scriptable scope;

    @Test
    public void testAnnotatedHostObject() {
        Context cx = Context.enter();
        try {
            Object result = this.evaluate(cx, "a = new AnnotatedHostObject(); a.initialized;");
            Assert.assertEquals((Object)result, (Object)Boolean.TRUE);
            Assert.assertEquals((Object)this.evaluate(cx, "a.instanceFunction();"), (Object)"instanceFunction");
            Assert.assertEquals((Object)this.evaluate(cx, "a.namedFunction();"), (Object)"namedFunction");
            Assert.assertEquals((Object)this.evaluate(cx, "AnnotatedHostObject.staticFunction();"), (Object)"staticFunction");
            Assert.assertEquals((Object)this.evaluate(cx, "AnnotatedHostObject.namedStaticFunction();"), (Object)"namedStaticFunction");
            Assert.assertNull((Object)this.evaluate(cx, "a.foo;"));
            Assert.assertEquals((Object)this.evaluate(cx, "a.foo = 'foo'; a.foo;"), (Object)"FOO");
            Assert.assertEquals((Object)this.evaluate(cx, "a.bar;"), (Object)"bar");
            this.evaluate(cx, "a.bar = 'new bar'");
            Assert.assertEquals((Object)"bar", (Object)this.evaluate(cx, "a.bar;"));
        }
        finally {
            Context.exit();
        }
    }

    @Test
    public void testTraditionalHostObject() {
        Context cx = Context.enter();
        try {
            Object result = this.evaluate(cx, "t = new TraditionalHostObject(); t.initialized;");
            Assert.assertEquals((Object)result, (Object)Boolean.TRUE);
            Assert.assertEquals((Object)this.evaluate(cx, "t.instanceFunction();"), (Object)"instanceFunction");
            Assert.assertEquals((Object)this.evaluate(cx, "TraditionalHostObject.staticFunction();"), (Object)"staticFunction");
            Assert.assertNull((Object)this.evaluate(cx, "t.foo;"));
            Assert.assertEquals((Object)this.evaluate(cx, "t.foo = 'foo'; t.foo;"), (Object)"FOO");
            Assert.assertEquals((Object)this.evaluate(cx, "t.bar;"), (Object)"bar");
            this.evaluate(cx, "t.bar = 'new bar'");
            Assert.assertEquals((Object)"bar", (Object)this.evaluate(cx, "t.bar;"));
        }
        finally {
            Context.exit();
        }
    }

    private Object evaluate(Context cx, String str) {
        return cx.evaluateString(this.scope, str, "<testsrc>", 0, null);
    }

    @Before
    public void init() throws Exception {
        Context cx = Context.enter();
        try {
            this.scope = cx.initStandardObjects();
            ScriptableObject.defineClass(this.scope, AnnotatedHostObject.class);
            ScriptableObject.defineClass(this.scope, TraditionalHostObject.class);
        }
        finally {
            Context.exit();
        }
    }

    public static class AnnotatedHostObject
    extends ScriptableObject {
        String foo;
        String bar = "bar";

        @Override
        public String getClassName() {
            return "AnnotatedHostObject";
        }

        @JSConstructor
        public void jsConstructorMethod() {
            this.put("initialized", (Scriptable)this, (Object)Boolean.TRUE);
        }

        @JSFunction
        public Object instanceFunction() {
            return "instanceFunction";
        }

        @JSFunction(value="namedFunction")
        public Object someFunctionName() {
            return "namedFunction";
        }

        @JSStaticFunction
        public static Object staticFunction() {
            return "staticFunction";
        }

        @JSStaticFunction(value="namedStaticFunction")
        public static Object someStaticFunctionName() {
            return "namedStaticFunction";
        }

        @JSGetter
        public String getFoo() {
            return this.foo;
        }

        @JSSetter
        public void setFoo(String foo) {
            this.foo = foo.toUpperCase();
        }

        @JSGetter(value="bar")
        public String getMyBar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar.toUpperCase();
        }
    }

    public static class TraditionalHostObject
    extends ScriptableObject {
        String foo;
        String bar = "bar";

        @Override
        public String getClassName() {
            return "TraditionalHostObject";
        }

        public void jsConstructor() {
            this.put("initialized", (Scriptable)this, (Object)Boolean.TRUE);
        }

        public Object jsFunction_instanceFunction() {
            return "instanceFunction";
        }

        public static Object jsStaticFunction_staticFunction() {
            return "staticFunction";
        }

        public String jsGet_foo() {
            return this.foo;
        }

        public void jsSet_foo(String foo) {
            this.foo = foo.toUpperCase();
        }

        public String jsGet_bar() {
            return this.bar;
        }

        public void setBar(String bar) {
            this.bar = bar.toUpperCase();
        }
    }
}

