/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import java.lang.reflect.Method;
import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class CustomSetterAcceptNullScriptableTest
extends TestCase {
    public void testSetNullForScriptableSetter() throws Exception {
        String scriptCode = "foo.myProp = new Foo2();\nfoo.myProp = null;";
        ContextFactory factory = new ContextFactory();
        Context cx = factory.enterContext();
        try {
            ScriptableObject topScope = cx.initStandardObjects();
            Foo foo = new Foo();
            Method setMyPropMethod = Foo.class.getMethod("setMyProp", Foo2.class);
            foo.defineProperty("myProp", null, null, setMyPropMethod, 0);
            topScope.put("foo", (Scriptable)topScope, (Object)foo);
            ScriptableObject.defineClass(topScope, Foo2.class);
            cx.evaluateString(topScope, "foo.myProp = new Foo2();\nfoo.myProp = null;", "myScript", 1, null);
        }
        finally {
            Context.exit();
        }
    }

    public static class Foo
    extends ScriptableObject {
        private static final long serialVersionUID = -8771045033217033529L;

        @Override
        public String getClassName() {
            return "Foo";
        }

        public void setMyProp(Foo2 s) {
        }
    }

    public static class Foo2
    extends ScriptableObject {
        private static final long serialVersionUID = -8880603824656138628L;

        @Override
        public String getClassName() {
            return "Foo2";
        }
    }
}

