/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Serializable;
import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContinuationPending;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrappedException;
import org.mozilla.javascript.serialize.ScriptableInputStream;
import org.mozilla.javascript.serialize.ScriptableOutputStream;

public class ContinuationsApiTest
extends TestCase {
    Scriptable globalScope;

    public void setUp() {
        Context cx = Context.enter();
        try {
            this.globalScope = cx.initStandardObjects();
            cx.setOptimizationLevel(-1);
            this.globalScope.put("myObject", this.globalScope, Context.javaToJS(new MyClass(), this.globalScope));
        }
        finally {
            Context.exit();
        }
    }

    public void testScriptWithContinuations() {
        Context cx = Context.enter();
        try {
            try {
                cx.setOptimizationLevel(-1);
                Script script = cx.compileString("myObject.f(3) + 1;", "test source", 1, null);
                cx.executeScriptWithContinuations(script, this.globalScope);
                ContinuationsApiTest.fail((String)"Should throw ContinuationPending");
            }
            catch (ContinuationPending pending) {
                Object applicationState = pending.getApplicationState();
                ContinuationsApiTest.assertEquals((Object)new Integer(3), (Object)applicationState);
                int saved = (Integer)applicationState;
                Object result = cx.resumeContinuation(pending.getContinuation(), this.globalScope, saved + 1);
                ContinuationsApiTest.assertEquals((int)5, (int)((Number)result).intValue());
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public void testScriptWithMultipleContinuations() {
        Context cx = Context.enter();
        try {
            try {
                cx.setOptimizationLevel(-1);
                Script script = cx.compileString("myObject.f(3) + myObject.g(3) + 2;", "test source", 1, null);
                cx.executeScriptWithContinuations(script, this.globalScope);
                ContinuationsApiTest.fail((String)"Should throw ContinuationPending");
            }
            catch (ContinuationPending pending) {
                try {
                    Object applicationState = pending.getApplicationState();
                    ContinuationsApiTest.assertEquals((Object)new Integer(3), (Object)applicationState);
                    int saved = (Integer)applicationState;
                    cx.resumeContinuation(pending.getContinuation(), this.globalScope, saved + 1);
                    ContinuationsApiTest.fail((String)"Should throw another ContinuationPending");
                }
                catch (ContinuationPending pending2) {
                    Object applicationState2 = pending2.getApplicationState();
                    ContinuationsApiTest.assertEquals((Object)new Integer(6), (Object)applicationState2);
                    int saved2 = (Integer)applicationState2;
                    Object result2 = cx.resumeContinuation(pending2.getContinuation(), this.globalScope, saved2 + 1);
                    ContinuationsApiTest.assertEquals((int)13, (int)((Number)result2).intValue());
                }
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public void testScriptWithNestedContinuations() {
        Context cx = Context.enter();
        try {
            try {
                cx.setOptimizationLevel(-1);
                Script script = cx.compileString("myObject.g( myObject.f(1) ) + 2;", "test source", 1, null);
                cx.executeScriptWithContinuations(script, this.globalScope);
                ContinuationsApiTest.fail((String)"Should throw ContinuationPending");
            }
            catch (ContinuationPending pending) {
                try {
                    Object applicationState = pending.getApplicationState();
                    ContinuationsApiTest.assertEquals((Object)new Integer(1), (Object)applicationState);
                    int saved = (Integer)applicationState;
                    cx.resumeContinuation(pending.getContinuation(), this.globalScope, saved + 1);
                    ContinuationsApiTest.fail((String)"Should throw another ContinuationPending");
                }
                catch (ContinuationPending pending2) {
                    Object applicationState2 = pending2.getApplicationState();
                    ContinuationsApiTest.assertEquals((Object)new Integer(4), (Object)applicationState2);
                    int saved2 = (Integer)applicationState2;
                    Object result2 = cx.resumeContinuation(pending2.getContinuation(), this.globalScope, saved2 + 2);
                    ContinuationsApiTest.assertEquals((int)8, (int)((Number)result2).intValue());
                }
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public void testFunctionWithContinuations() {
        Context cx = Context.enter();
        try {
            try {
                cx.setOptimizationLevel(-1);
                cx.evaluateString(this.globalScope, "function f(a) { return myObject.f(a); }", "function test source", 1, null);
                Function f = (Function)this.globalScope.get("f", this.globalScope);
                Object[] args = new Object[]{7};
                cx.callFunctionWithContinuations(f, this.globalScope, args);
                ContinuationsApiTest.fail((String)"Should throw ContinuationPending");
            }
            catch (ContinuationPending pending) {
                Object applicationState = pending.getApplicationState();
                ContinuationsApiTest.assertEquals((int)7, (int)((Number)applicationState).intValue());
                int saved = (Integer)applicationState;
                Object result = cx.resumeContinuation(pending.getContinuation(), this.globalScope, saved + 1);
                ContinuationsApiTest.assertEquals((int)8, (int)((Number)result).intValue());
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public void testErrorOnEvalCall() {
        Context cx = Context.enter();
        try {
            try {
                cx.setOptimizationLevel(-1);
                Script script = cx.compileString("eval('myObject.f(3);');", "test source", 1, null);
                cx.executeScriptWithContinuations(script, this.globalScope);
                ContinuationsApiTest.fail((String)"Should throw IllegalStateException");
            }
            catch (WrappedException we) {
                Throwable t = we.getWrappedException();
                ContinuationsApiTest.assertTrue((boolean)(t instanceof IllegalStateException));
                ContinuationsApiTest.assertTrue((boolean)t.getMessage().startsWith("Cannot capture continuation"));
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public void testSerializationWithContinuations() throws IOException, ClassNotFoundException {
        Context cx = Context.enter();
        try {
            try {
                cx.setOptimizationLevel(-1);
                cx.evaluateString(this.globalScope, "function f(a) { var k = myObject.f(a); var t = []; return k; }", "function test source", 1, null);
                Function f = (Function)this.globalScope.get("f", this.globalScope);
                Object[] args = new Object[]{7};
                cx.callFunctionWithContinuations(f, this.globalScope, args);
                ContinuationsApiTest.fail((String)"Should throw ContinuationPending");
            }
            catch (ContinuationPending pending) {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                ScriptableOutputStream sos = new ScriptableOutputStream(baos, this.globalScope);
                sos.writeObject(this.globalScope);
                sos.writeObject(pending.getContinuation());
                sos.close();
                baos.close();
                byte[] serializedData = baos.toByteArray();
                ByteArrayInputStream bais = new ByteArrayInputStream(serializedData);
                ScriptableInputStream sis = new ScriptableInputStream(bais, this.globalScope);
                this.globalScope = (Scriptable)sis.readObject();
                Object continuation = sis.readObject();
                sis.close();
                bais.close();
                Object result = cx.resumeContinuation(continuation, this.globalScope, 8);
                ContinuationsApiTest.assertEquals((int)8, (int)((Number)result).intValue());
                Context.exit();
            }
        }
        finally {
            Context.exit();
        }
    }

    public static class MyClass
    implements Serializable {
        private static final long serialVersionUID = 4189002778806232070L;

        public int f(int a) {
            Context cx = Context.enter();
            try {
                ContinuationPending pending = cx.captureContinuation();
                pending.setApplicationState(a);
                throw pending;
            }
            catch (Throwable throwable) {
                Context.exit();
                throw throwable;
            }
        }

        public int g(int a) {
            Context cx = Context.enter();
            try {
                ContinuationPending pending = cx.captureContinuation();
                pending.setApplicationState(2 * a);
                throw pending;
            }
            catch (Throwable throwable) {
                Context.exit();
                throw throwable;
            }
        }
    }
}

