/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.ScriptableObject;

public class ClassShutterExceptionTest
extends TestCase {
    private static Context.ClassShutterSetter classShutterSetter;

    public void helper(String source) {
        Context cx = Context.enter();
        Context.ClassShutterSetter setter = cx.getClassShutterSetter();
        try {
            ScriptableObject globalScope = cx.initStandardObjects();
            if (setter == null) {
                setter = classShutterSetter;
            } else {
                classShutterSetter = setter;
            }
            setter.setClassShutter(new OpaqueShutter());
            cx.evaluateString(globalScope, source, "test source", 1, null);
        }
        finally {
            setter.setClassShutter(null);
            Context.exit();
        }
    }

    public void testClassShutterException() {
        try {
            this.helper("java.lang.System.out.println('hi');");
            ClassShutterExceptionTest.fail();
        }
        catch (RhinoException e) {
            return;
        }
    }

    public void testThrowingException() {
        this.helper("try { throw 3; } catch (e) { }");
    }

    public void testThrowingEcmaError() {
        try {
            this.helper("friggin' syntax error!");
            ClassShutterExceptionTest.fail((String)"Should have thrown an exception");
        }
        catch (EvaluatorException evaluatorException) {
            // empty catch block
        }
    }

    public void testThrowingEvaluatorException() {
        this.helper("try { eval('for;if;else'); } catch (e) { }");
    }

    static class OpaqueShutter
    implements ClassShutter {
        OpaqueShutter() {
        }

        @Override
        public boolean visibleToScripts(String name) {
            return false;
        }
    }
}

