/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public class Bug466207Test
extends TestCase {
    List<Object> list;
    List<Object> reference;

    protected void setUp() {
        this.reference = new ArrayList<Object>();
        this.reference.add("a");
        this.reference.add(Boolean.TRUE);
        this.reference.add(new HashMap());
        this.reference.add(new Integer(42));
        this.reference.add("a");
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        this.list = (List)context.evaluateString(scope, "(['a', true, new java.util.HashMap(), 42, 'a']);", "testsrc", 1, null);
        Context.exit();
    }

    public void testEqual() {
        Bug466207Test.assertEquals(this.reference, this.list);
    }

    public void testIndexedAccess() {
        Bug466207Test.assertTrue((this.list.size() == 5 ? 1 : 0) != 0);
        Bug466207Test.assertEquals((Object)this.list.get(0), (Object)this.reference.get(0));
        Bug466207Test.assertEquals((Object)this.list.get(1), (Object)this.reference.get(1));
        Bug466207Test.assertEquals((Object)this.list.get(2), (Object)this.reference.get(2));
        Bug466207Test.assertEquals((Object)this.list.get(3), (Object)this.reference.get(3));
        Bug466207Test.assertEquals((Object)this.list.get(4), (Object)this.reference.get(4));
    }

    public void testContains() {
        Bug466207Test.assertTrue((boolean)this.list.contains("a"));
        Bug466207Test.assertTrue((boolean)this.list.contains(Boolean.TRUE));
        Bug466207Test.assertFalse((boolean)this.list.contains("x"));
        Bug466207Test.assertFalse((boolean)this.list.contains(Boolean.FALSE));
        Bug466207Test.assertFalse((boolean)this.list.contains(null));
    }

    public void testIndexOf() {
        Bug466207Test.assertTrue((this.list.indexOf("a") == 0 ? 1 : 0) != 0);
        Bug466207Test.assertTrue((this.list.indexOf(Boolean.TRUE) == 1 ? 1 : 0) != 0);
        Bug466207Test.assertTrue((this.list.lastIndexOf("a") == 4 ? 1 : 0) != 0);
        Bug466207Test.assertTrue((this.list.lastIndexOf(Boolean.TRUE) == 1 ? 1 : 0) != 0);
        Bug466207Test.assertTrue((this.list.indexOf("x") == -1 ? 1 : 0) != 0);
        Bug466207Test.assertTrue((this.list.lastIndexOf("x") == -1 ? 1 : 0) != 0);
        Bug466207Test.assertTrue((this.list.indexOf(null) == -1 ? 1 : 0) != 0);
        Bug466207Test.assertTrue((this.list.lastIndexOf(null) == -1 ? 1 : 0) != 0);
    }

    public void testToArray() {
        Bug466207Test.assertTrue((boolean)Arrays.equals(this.list.toArray(), this.reference.toArray()));
        Bug466207Test.assertTrue((boolean)Arrays.equals(this.list.toArray(new Object[5]), this.reference.toArray(new Object[5])));
        Bug466207Test.assertTrue((boolean)Arrays.equals(this.list.toArray(new Object[6]), this.reference.toArray(new Object[6])));
    }

    public void testIterator() {
        this.compareIterators(this.list.iterator(), this.reference.iterator());
        this.compareIterators(this.list.listIterator(), this.reference.listIterator());
        this.compareIterators(this.list.listIterator(2), this.reference.listIterator(2));
        this.compareIterators(this.list.listIterator(3), this.reference.listIterator(3));
        this.compareIterators(this.list.listIterator(5), this.reference.listIterator(5));
        this.compareListIterators(this.list.listIterator(), this.reference.listIterator());
        this.compareListIterators(this.list.listIterator(2), this.reference.listIterator(2));
        this.compareListIterators(this.list.listIterator(3), this.reference.listIterator(3));
        this.compareListIterators(this.list.listIterator(5), this.reference.listIterator(5));
    }

    private void compareIterators(Iterator it1, Iterator it2) {
        while (it1.hasNext()) {
            Bug466207Test.assertEquals(it1.next(), it2.next());
        }
        Bug466207Test.assertFalse((boolean)it2.hasNext());
    }

    private void compareListIterators(ListIterator it1, ListIterator it2) {
        while (it1.hasPrevious()) {
            Bug466207Test.assertEquals(it1.previous(), it2.previous());
        }
        Bug466207Test.assertFalse((boolean)it2.hasPrevious());
        this.compareIterators(it1, it2);
    }
}

