/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ScriptableObject;

public class Bug448816Test
extends TestCase {
    Map<Object, Object> map;
    Map<Object, Object> reference;

    protected void setUp() {
        this.reference = new LinkedHashMap<Object, Object>();
        this.reference.put("a", "a");
        this.reference.put("b", Boolean.TRUE);
        this.reference.put("c", new HashMap());
        this.reference.put(new Integer(1), new Integer(42));
        Context context = Context.enter();
        ScriptableObject scope = context.initStandardObjects();
        this.map = (Map)context.evaluateString(scope, "({ a: 'a', b: true, c: new java.util.HashMap(), 1: 42});", "testsrc", 1, null);
        Context.exit();
    }

    public void testEqual() {
        Bug448816Test.assertEquals(this.reference, this.map);
    }

    public void testBasicAccess() {
        Bug448816Test.assertTrue((this.map.size() == 4 ? 1 : 0) != 0);
        Bug448816Test.assertEquals((Object)this.map.get("a"), (Object)this.reference.get("a"));
        Bug448816Test.assertEquals((Object)this.map.get("b"), (Object)this.reference.get("b"));
        Bug448816Test.assertEquals((Object)this.map.get("c"), (Object)this.reference.get("c"));
        Bug448816Test.assertEquals((Object)this.map.get(new Integer(1)), (Object)this.reference.get(new Integer(1)));
        Bug448816Test.assertEquals((Object)this.map.get("notfound"), (Object)this.reference.get("notfound"));
        Bug448816Test.assertTrue((boolean)this.map.containsKey("b"));
        Bug448816Test.assertTrue((boolean)this.map.containsValue(Boolean.TRUE));
        Bug448816Test.assertFalse((boolean)this.map.containsKey("x"));
        Bug448816Test.assertFalse((boolean)this.map.containsValue(Boolean.FALSE));
        Bug448816Test.assertFalse((boolean)this.map.containsValue(null));
    }

    public void testCollections() {
        Bug448816Test.assertEquals(this.map.keySet(), this.reference.keySet());
        Bug448816Test.assertEquals(this.map.entrySet(), this.reference.entrySet());
        Bug448816Test.assertTrue((boolean)this.map.values().containsAll(this.reference.values()));
        Bug448816Test.assertTrue((boolean)this.reference.values().containsAll(this.map.values()));
    }

    public void testRemoval() {
        Bug448816Test.assertTrue((this.map.size() == 4 ? 1 : 0) != 0);
        Bug448816Test.assertEquals((Object)this.map.remove("b"), (Object)Boolean.TRUE);
        this.reference.remove("b");
        Bug448816Test.assertTrue((this.map.size() == 3 ? 1 : 0) != 0);
        Bug448816Test.assertEquals(this.reference, this.map);
        this.testCollections();
    }

    public void testKeyIterator() {
        this.compareIterators(this.map.keySet().iterator(), this.reference.keySet().iterator());
    }

    public void testEntryIterator() {
        this.compareIterators(this.map.entrySet().iterator(), this.reference.entrySet().iterator());
    }

    public void testValueIterator() {
        this.compareIterators(this.map.values().iterator(), this.reference.values().iterator());
    }

    private void compareIterators(Iterator it1, Iterator it2) {
        Bug448816Test.assertTrue((this.map.size() == 4 ? 1 : 0) != 0);
        while (it1.hasNext()) {
            Bug448816Test.assertEquals(it1.next(), it2.next());
            it1.remove();
            it2.remove();
        }
        Bug448816Test.assertTrue((boolean)this.map.isEmpty());
    }
}

