/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.tests;

import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.ImporterTopLevel;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;

public class Bug421071Test
extends TestCase {
    private ContextFactory factory;
    private TopLevelScope globalScope;
    private Script testScript;

    public void testProblemReplicator() throws Exception {
        this.testScript = this.compileScript();
        this.runTestScript();
        this.runTestScript();
    }

    private Script compileScript() {
        String scriptSource = "importPackage(java.util);\nvar searchmon = 3;\nvar searchday = 10;\nvar searchyear = 2008;\nvar searchwkday = 0;\n\nvar myDate = Calendar.getInstance();\n // this is a java.util.CalendarmyDate.set(Calendar.MONTH, searchmon);\nmyDate.set(Calendar.DATE, searchday);\nmyDate.set(Calendar.YEAR, searchyear);\nsearchwkday.value = myDate.get(Calendar.DAY_OF_WEEK);";
        Context context = this.factory.enterContext();
        try {
            Script script;
            Script script2 = script = context.compileString(scriptSource, "testScript", 1, null);
            return script2;
        }
        finally {
            Context.exit();
        }
    }

    private void runTestScript() throws InterruptedException {
        Thread thread = new Thread(new ScriptRunner(this.testScript));
        thread.start();
        thread.join();
    }

    private TopLevelScope createGlobalScope() {
        this.factory = new DynamicScopeContextFactory();
        Context context = this.factory.enterContext();
        TopLevelScope globalScope = new TopLevelScope(context);
        Context.exit();
        return globalScope;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.globalScope = this.createGlobalScope();
    }

    static class DynamicScopeContextFactory
    extends ContextFactory {
        DynamicScopeContextFactory() {
        }

        @Override
        public boolean hasFeature(Context cx, int featureIndex) {
            if (featureIndex == 7) {
                return true;
            }
            return super.hasFeature(cx, featureIndex);
        }
    }

    private class ScriptRunner
    implements Runnable {
        private Script script;

        public ScriptRunner(Script script) {
            this.script = script;
        }

        @Override
        public void run() {
            Context context = Bug421071Test.this.factory.enterContext();
            try {
                try {
                    Scriptable threadScope = context.newObject(Bug421071Test.this.globalScope);
                    threadScope.setPrototype(Bug421071Test.this.globalScope);
                    threadScope.setParentScope(null);
                    this.script.exec(context, threadScope);
                }
                catch (Exception ee) {
                    ee.printStackTrace();
                    Context.exit();
                }
            }
            finally {
                Context.exit();
            }
        }
    }

    private class TopLevelScope
    extends ImporterTopLevel {
        private static final long serialVersionUID = 7831526694313927899L;

        public TopLevelScope(Context context) {
            super(context);
        }
    }
}

