/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.regexp;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.RegExpProxy;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;
import org.mozilla.javascript.regexp.GlobData;
import org.mozilla.javascript.regexp.NativeRegExp;
import org.mozilla.javascript.regexp.SubString;

public class RegExpImpl
implements RegExpProxy {
    protected String input;
    protected boolean multiline;
    protected SubString[] parens;
    protected SubString lastMatch;
    protected SubString lastParen;
    protected SubString leftContext;
    protected SubString rightContext;

    @Override
    public boolean isRegExp(Scriptable obj) {
        return obj instanceof NativeRegExp;
    }

    @Override
    public Object compileRegExp(Context cx, String source, String flags) {
        return NativeRegExp.compileRE(cx, source, flags, false);
    }

    @Override
    public Scriptable wrapRegExp(Context cx, Scriptable scope, Object compiled) {
        return new NativeRegExp(scope, compiled);
    }

    @Override
    public Object action(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, int actionType) {
        GlobData data = new GlobData();
        data.mode = actionType;
        switch (actionType) {
            case 1: {
                data.optarg = 1;
                Object rval = RegExpImpl.matchOrReplace(cx, scope, thisObj, args, this, data, false);
                return data.arrayobj == null ? rval : data.arrayobj;
            }
            case 3: {
                data.optarg = 1;
                return RegExpImpl.matchOrReplace(cx, scope, thisObj, args, this, data, false);
            }
            case 2: {
                Object arg1 = args.length < 2 ? Undefined.instance : args[1];
                String repstr = null;
                Function lambda = null;
                if (arg1 instanceof Function) {
                    lambda = (Function)arg1;
                } else {
                    repstr = ScriptRuntime.toString(arg1);
                }
                data.optarg = 2;
                data.lambda = lambda;
                data.repstr = repstr;
                data.dollar = repstr == null ? -1 : repstr.indexOf(36);
                data.charBuf = null;
                data.leftIndex = 0;
                Object val = RegExpImpl.matchOrReplace(cx, scope, thisObj, args, this, data, true);
                SubString rc = this.rightContext;
                if (data.charBuf == null) {
                    if (data.global || val == null || !val.equals(Boolean.TRUE)) {
                        return data.str;
                    }
                    SubString lc = this.leftContext;
                    RegExpImpl.replace_glob(data, cx, scope, this, lc.index, lc.length);
                }
                data.charBuf.append(rc.charArray, rc.index, rc.length);
                return data.charBuf.toString();
            }
        }
        throw Kit.codeBug();
    }

    private static Object matchOrReplace(Context cx, Scriptable scope, Scriptable thisObj, Object[] args, RegExpImpl reImpl, GlobData data, boolean forceFlat) {
        NativeRegExp re;
        String str;
        data.str = str = ScriptRuntime.toString(thisObj);
        Scriptable topScope = ScriptableObject.getTopLevelScope(scope);
        if (args.length == 0) {
            Object compiled = NativeRegExp.compileRE(cx, "", "", false);
            re = new NativeRegExp(topScope, compiled);
        } else if (args[0] instanceof NativeRegExp) {
            re = (NativeRegExp)args[0];
        } else {
            String opt;
            String src = ScriptRuntime.toString(args[0]);
            if (data.optarg < args.length) {
                args[0] = src;
                opt = ScriptRuntime.toString(args[data.optarg]);
            } else {
                opt = null;
            }
            Object compiled = NativeRegExp.compileRE(cx, src, opt, forceFlat);
            re = new NativeRegExp(topScope, compiled);
        }
        data.global = (re.getFlags() & 1) != 0;
        int[] indexp = new int[1];
        Object result = null;
        if (data.mode == 3) {
            result = re.executeRegExp(cx, scope, reImpl, str, indexp, 0);
            result = result != null && result.equals(Boolean.TRUE) ? Integer.valueOf(reImpl.leftContext.length) : Integer.valueOf(-1);
        } else if (data.global) {
            re.lastIndex = 0.0;
            int count = 0;
            while (indexp[0] <= str.length()) {
                result = re.executeRegExp(cx, scope, reImpl, str, indexp, 0);
                if (result == null || !result.equals(Boolean.TRUE)) break;
                if (data.mode == 1) {
                    RegExpImpl.match_glob(data, cx, scope, count, reImpl);
                } else {
                    if (data.mode != 2) {
                        Kit.codeBug();
                    }
                    SubString lastMatch = reImpl.lastMatch;
                    int leftIndex = data.leftIndex;
                    int leftlen = lastMatch.index - leftIndex;
                    data.leftIndex = lastMatch.index + lastMatch.length;
                    RegExpImpl.replace_glob(data, cx, scope, reImpl, leftIndex, leftlen);
                }
                if (reImpl.lastMatch.length == 0) {
                    if (indexp[0] == str.length()) break;
                    indexp[0] = indexp[0] + 1;
                }
                ++count;
            }
        } else {
            result = re.executeRegExp(cx, scope, reImpl, str, indexp, data.mode == 2 ? 0 : 1);
        }
        return result;
    }

    @Override
    public int find_split(Context cx, Scriptable scope, String target, String separator, Scriptable reObj, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        int result;
        block6: {
            int i;
            block5: {
                i = ip[0];
                int length = target.length();
                int version = cx.getLanguageVersion();
                NativeRegExp re = (NativeRegExp)reObj;
                do {
                    int ipsave = ip[0];
                    ip[0] = ++i;
                    Object ret = re.executeRegExp(cx, scope, this, target, ip, 0);
                    if (ret != Boolean.TRUE) {
                        ip[0] = ipsave;
                        matchlen[0] = 1;
                        matched[0] = false;
                        return length;
                    }
                    i = ip[0];
                    ip[0] = ipsave;
                    matched[0] = true;
                    SubString sep = this.lastMatch;
                    matchlen[0] = sep.length;
                    if (matchlen[0] != 0 || i != ip[0]) break block5;
                } while (i != length);
                if (version == 120) {
                    matchlen[0] = 1;
                    result = i;
                } else {
                    result = -1;
                }
                break block6;
            }
            result = i - matchlen[0];
        }
        int size = this.parens == null ? 0 : this.parens.length;
        parensp[0] = new String[size];
        int num = 0;
        while (num < size) {
            SubString parsub = this.getParenSubString(num);
            parensp[0][num] = parsub.toString();
            ++num;
        }
        return result;
    }

    SubString getParenSubString(int i) {
        SubString parsub;
        if (this.parens != null && i < this.parens.length && (parsub = this.parens[i]) != null) {
            return parsub;
        }
        return SubString.emptySubString;
    }

    private static void match_glob(GlobData mdata, Context cx, Scriptable scope, int count, RegExpImpl reImpl) {
        if (mdata.arrayobj == null) {
            mdata.arrayobj = cx.newArray(scope, 0);
        }
        SubString matchsub = reImpl.lastMatch;
        String matchstr = matchsub.toString();
        mdata.arrayobj.put(count, mdata.arrayobj, (Object)matchstr);
    }

    private static void replace_glob(GlobData rdata, Context cx, Scriptable scope, RegExpImpl reImpl, int leftIndex, int leftlen) {
        int replen;
        String lambdaStr;
        if (rdata.lambda != null) {
            SubString[] parens = reImpl.parens;
            int parenCount = parens == null ? 0 : parens.length;
            Object[] args = new Object[parenCount + 3];
            args[0] = reImpl.lastMatch.toString();
            int i = 0;
            while (i < parenCount) {
                SubString sub = parens[i];
                args[i + 1] = sub != null ? sub.toString() : Undefined.instance;
                ++i;
            }
            args[parenCount + 1] = reImpl.leftContext.length;
            args[parenCount + 2] = rdata.str;
            if (reImpl != ScriptRuntime.getRegExpProxy(cx)) {
                Kit.codeBug();
            }
            RegExpImpl re2 = new RegExpImpl();
            re2.multiline = reImpl.multiline;
            re2.input = reImpl.input;
            ScriptRuntime.setRegExpProxy(cx, re2);
            try {
                Scriptable parent = ScriptableObject.getTopLevelScope(scope);
                Object result = rdata.lambda.call(cx, parent, parent, args);
                lambdaStr = ScriptRuntime.toString(result);
            }
            finally {
                ScriptRuntime.setRegExpProxy(cx, reImpl);
            }
            replen = lambdaStr.length();
        } else {
            lambdaStr = null;
            replen = rdata.repstr.length();
            if (rdata.dollar >= 0) {
                int[] skip = new int[1];
                int dp = rdata.dollar;
                do {
                    SubString sub;
                    if ((sub = RegExpImpl.interpretDollar(cx, reImpl, rdata.repstr, dp, skip)) != null) {
                        replen += sub.length - skip[0];
                        dp += skip[0];
                        continue;
                    }
                    ++dp;
                } while ((dp = rdata.repstr.indexOf(36, dp)) >= 0);
            }
        }
        int growth = leftlen + replen + reImpl.rightContext.length;
        StringBuffer charBuf = rdata.charBuf;
        if (charBuf == null) {
            rdata.charBuf = charBuf = new StringBuffer(growth);
        } else {
            charBuf.ensureCapacity(rdata.charBuf.length() + growth);
        }
        charBuf.append(reImpl.leftContext.charArray, leftIndex, leftlen);
        if (rdata.lambda != null) {
            charBuf.append(lambdaStr);
        } else {
            RegExpImpl.do_replace(rdata, cx, reImpl);
        }
    }

    private static SubString interpretDollar(Context cx, RegExpImpl res, String da, int dp, int[] skip) {
        int version;
        if (da.charAt(dp) != '$') {
            Kit.codeBug();
        }
        if ((version = cx.getLanguageVersion()) != 0 && version <= 140 && dp > 0 && da.charAt(dp - 1) == '\\') {
            return null;
        }
        int daL = da.length();
        if (dp + 1 >= daL) {
            return null;
        }
        char dc = da.charAt(dp + 1);
        if (NativeRegExp.isDigit(dc)) {
            int tmp;
            int cp;
            int num;
            if (version != 0 && version <= 140) {
                if (dc == '0') {
                    return null;
                }
                num = 0;
                cp = dp;
                while (++cp < daL && NativeRegExp.isDigit(dc = da.charAt(cp))) {
                    tmp = 10 * num + (dc - 48);
                    if (tmp >= num) {
                        num = tmp;
                        continue;
                    }
                    break;
                }
            } else {
                num = dc - 48;
                int parenCount = res.parens == null ? 0 : res.parens.length;
                if (num > parenCount) {
                    return null;
                }
                cp = dp + 2;
                if (dp + 2 < daL && NativeRegExp.isDigit(dc = da.charAt(dp + 2)) && (tmp = 10 * num + (dc - 48)) <= parenCount) {
                    ++cp;
                    num = tmp;
                }
                if (num == 0) {
                    return null;
                }
            }
            skip[0] = cp - dp;
            return res.getParenSubString(--num);
        }
        skip[0] = 2;
        switch (dc) {
            case '$': {
                return new SubString("$");
            }
            case '&': {
                return res.lastMatch;
            }
            case '+': {
                return res.lastParen;
            }
            case '`': {
                if (version == 120) {
                    res.leftContext.index = 0;
                    res.leftContext.length = res.lastMatch.index;
                }
                return res.leftContext;
            }
            case '\'': {
                return res.rightContext;
            }
        }
        return null;
    }

    private static void do_replace(GlobData rdata, Context cx, RegExpImpl regExpImpl) {
        int daL;
        StringBuffer charBuf = rdata.charBuf;
        int cp = 0;
        String da = rdata.repstr;
        int dp = rdata.dollar;
        if (dp != -1) {
            int[] skip = new int[1];
            do {
                int len = dp - cp;
                charBuf.append(da.substring(cp, dp));
                cp = dp;
                SubString sub = RegExpImpl.interpretDollar(cx, regExpImpl, da, dp, skip);
                if (sub != null) {
                    len = sub.length;
                    if (len > 0) {
                        charBuf.append(sub.charArray, sub.index, len);
                    }
                    cp += skip[0];
                    dp += skip[0];
                    continue;
                }
                ++dp;
            } while ((dp = da.indexOf(36, dp)) >= 0);
        }
        if ((daL = da.length()) > cp) {
            charBuf.append(da.substring(cp, daL));
        }
    }

    @Override
    public Object js_split(Context cx, Scriptable scope, String target, Object[] args) {
        int match;
        Scriptable test;
        Scriptable result = cx.newArray(scope, 0);
        if (args.length < 1) {
            result.put(0, result, (Object)target);
            return result;
        }
        boolean limited = args.length > 1 && args[1] != Undefined.instance;
        long limit = 0L;
        if (limited && (limit = ScriptRuntime.toUint32(args[1])) > (long)target.length()) {
            limit = 1 + target.length();
        }
        String separator = null;
        int[] matchlen = new int[1];
        Scriptable re = null;
        RegExpProxy reProxy = null;
        if (args[0] instanceof Scriptable && (reProxy = ScriptRuntime.getRegExpProxy(cx)) != null && reProxy.isRegExp(test = (Scriptable)args[0])) {
            re = test;
        }
        if (re == null) {
            separator = ScriptRuntime.toString(args[0]);
            matchlen[0] = separator.length();
        }
        int[] ip = new int[1];
        int len = 0;
        boolean[] matched = new boolean[1];
        String[][] parens = new String[1][];
        int version = cx.getLanguageVersion();
        while ((match = RegExpImpl.find_split(cx, scope, target, separator, version, reProxy, re, ip, matchlen, matched, parens)) >= 0) {
            if (limited && (long)len >= limit || match > target.length()) break;
            String substr = target.length() == 0 ? target : target.substring(ip[0], match);
            result.put(len, result, (Object)substr);
            ++len;
            if (re != null && matched[0]) {
                int size = parens[0].length;
                int num = 0;
                while (num < size) {
                    if (limited && (long)len >= limit) break;
                    result.put(len, result, (Object)parens[0][num]);
                    ++len;
                    ++num;
                }
                matched[0] = false;
            }
            ip[0] = match + matchlen[0];
            if (version < 130 && version != 0 && !limited && ip[0] == target.length()) break;
        }
        return result;
    }

    /*
     * Unable to fully structure code
     */
    private static int find_split(Context cx, Scriptable scope, String target, String separator, int version, RegExpProxy reProxy, Scriptable re, int[] ip, int[] matchlen, boolean[] matched, String[][] parensp) {
        block11: {
            i = ip[0];
            length = target.length();
            if (version != 120 || re != null || separator.length() != 1 || separator.charAt(0) != ' ') break block11;
            if (i == 0) {
                while (i < length && Character.isWhitespace(target.charAt(i))) {
                    ++i;
                }
                ip[0] = i;
            }
            if (i != length) ** GOTO lbl12
            return -1;
lbl-1000:
            // 1 sources

            {
                ++i;
lbl12:
                // 2 sources

                ** while (i < length && !Character.isWhitespace((char)target.charAt((int)i)))
            }
lbl13:
            // 1 sources

            j = i;
            while (j < length && Character.isWhitespace(target.charAt(j))) {
                ++j;
            }
            matchlen[0] = j - i;
            return i;
        }
        if (i > length) {
            return -1;
        }
        if (re != null) {
            return reProxy.find_split(cx, scope, target, separator, re, ip, matchlen, matched, parensp);
        }
        if (version != 0 && version < 130 && length == 0) {
            return -1;
        }
        if (separator.length() == 0) {
            if (version == 120) {
                if (i == length) {
                    matchlen[0] = 1;
                    return i;
                }
                return i + 1;
            }
            return i == length ? -1 : i + 1;
        }
        if (ip[0] >= length) {
            return length;
        }
        i = target.indexOf(separator, ip[0]);
        return i != -1 ? i : length;
    }
}

