/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.drivers;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.drivers.StandardTests;

public class TestUtils {
    private static ContextFactory.GlobalSetter globalSetter;

    public static void grabContextFactoryGlobalSetter() {
        if (globalSetter == null) {
            globalSetter = ContextFactory.getGlobalSetter();
        }
    }

    public static void setGlobalContextFactory(ContextFactory factory) {
        TestUtils.grabContextFactoryGlobalSetter();
        globalSetter.setContextFactoryGlobal(factory);
    }

    public static File[] recursiveListFiles(File dir, FileFilter filter) {
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(dir + " is not a directory");
        }
        ArrayList<File> fileList = new ArrayList<File>();
        TestUtils.recursiveListFilesHelper(dir, filter, fileList);
        return fileList.toArray(new File[fileList.size()]);
    }

    public static void recursiveListFilesHelper(File dir, FileFilter filter, List<File> fileList) {
        File[] fileArray = dir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (f.isDirectory()) {
                TestUtils.recursiveListFilesHelper(f, filter, fileList);
            } else if (filter.accept(f)) {
                fileList.add(f);
            }
            ++n2;
        }
    }

    public static void addTestsFromFile(String filename, List<String> list) throws IOException {
        TestUtils.addTestsFromStream(new FileInputStream(new File(filename)), list);
    }

    public static void addTestsFromStream(InputStream in, List<String> list) throws IOException {
        Properties props = new Properties();
        props.load(in);
        for (Object obj : props.keySet()) {
            list.add(obj.toString());
        }
    }

    public static String[] loadTestsFromResource(String resource, String[] inherited) throws IOException {
        ArrayList<String> list = inherited == null ? new ArrayList<String>() : new ArrayList<String>(Arrays.asList(inherited));
        InputStream in = StandardTests.class.getResourceAsStream(resource);
        if (in != null) {
            TestUtils.addTestsFromStream(in, list);
        }
        return list.toArray(new String[0]);
    }

    public static boolean matches(String[] patterns, String path) {
        int i = 0;
        while (i < patterns.length) {
            if (path.startsWith(patterns[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

