/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.drivers;

import java.io.File;
import java.util.Arrays;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.mozilla.javascript.drivers.ShellTest;
import org.mozilla.javascript.drivers.TestUtils;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

public class StandardTests
extends TestSuite {
    private static final boolean DISABLE = true;

    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite("Standard JavaScript tests");
        return suite;
    }

    private static void addSuites(TestSuite topLevel, File testDir, String[] excludes, int optimizationLevel) {
        Object[] subdirs = testDir.listFiles(ShellTest.DIRECTORY_FILTER);
        Arrays.sort(subdirs);
        int i = 0;
        while (i < subdirs.length) {
            Object subdir = subdirs[i];
            String name = ((File)subdir).getName();
            if (!TestUtils.matches(excludes, name)) {
                TestSuite testSuite = new TestSuite(name);
                StandardTests.addCategories(testSuite, (File)subdir, String.valueOf(name) + "/", excludes, optimizationLevel);
                topLevel.addTest((Test)testSuite);
            }
            ++i;
        }
    }

    private static void addCategories(TestSuite suite, File suiteDir, String prefix, String[] excludes, int optimizationLevel) {
        Object[] subdirs = suiteDir.listFiles(ShellTest.DIRECTORY_FILTER);
        Arrays.sort(subdirs);
        int i = 0;
        while (i < subdirs.length) {
            Object subdir = subdirs[i];
            String name = ((File)subdir).getName();
            TestSuite testCategory = new TestSuite(name);
            StandardTests.addTests(testCategory, (File)subdir, String.valueOf(prefix) + name + "/", excludes, optimizationLevel);
            suite.addTest((Test)testCategory);
            ++i;
        }
    }

    private static void addTests(TestSuite suite, File suiteDir, String prefix, String[] excludes, int optimizationLevel) {
        Object[] jsFiles = suiteDir.listFiles(ShellTest.TEST_FILTER);
        Arrays.sort(jsFiles);
        int i = 0;
        while (i < jsFiles.length) {
            Object jsFile = jsFiles[i];
            String name = ((File)jsFile).getName();
            if (!TestUtils.matches(excludes, String.valueOf(prefix) + name)) {
                suite.addTest((Test)new JsTestCase((File)jsFile, optimizationLevel));
            }
            ++i;
        }
    }

    public static final class JsTestCase
    extends TestCase {
        private final File jsFile;
        private final int optimizationLevel;

        JsTestCase(File jsFile, int optimizationLevel) {
            super(String.valueOf(jsFile.getName()) + (optimizationLevel == 1 ? "-compiled" : "-interpreted"));
            this.jsFile = jsFile;
            this.optimizationLevel = optimizationLevel;
        }

        public int countTestCases() {
            return 1;
        }

        public void runBare() throws Exception {
            ShellContextFactory shellContextFactory = new ShellContextFactory();
            shellContextFactory.setOptimizationLevel(this.optimizationLevel);
            ShellTestParameters params = new ShellTestParameters();
            ShellTest.run(shellContextFactory, this.jsFile, params, new JunitStatus());
        }

        public static class ShellTestParameters
        extends ShellTest.Parameters {
            @Override
            public int getTimeoutMilliseconds() {
                if (System.getProperty("mozilla.js.tests.timeout") != null) {
                    return Integer.parseInt(System.getProperty("mozilla.js.tests.timeout"));
                }
                return 60000;
            }
        }
    }

    public static class JunitStatus
    extends ShellTest.Status {
        @Override
        public final void running(File jsFile) {
        }

        @Override
        public final void failed(String s) {
            Assert.fail((String)s);
        }

        @Override
        public final void exitCodesWere(int expected, int actual) {
            Assert.assertEquals((String)"Unexpected exit code", (int)expected, (int)actual);
        }

        @Override
        public final void outputWas(String s) {
        }

        @Override
        public final void threw(Throwable t) {
            Assert.fail((String)ShellTest.getStackTrace(t));
        }

        @Override
        public final void timedOut() {
            this.failed("Timed out.");
        }
    }
}

