/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.drivers;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextAction;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.tools.shell.Global;
import org.mozilla.javascript.tools.shell.Main;
import org.mozilla.javascript.tools.shell.ShellContextFactory;

public class ShellTest {
    public static final FileFilter DIRECTORY_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.isDirectory() && !pathname.getName().equals("CVS");
        }
    };
    public static final FileFilter TEST_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            return pathname.getName().endsWith(".js") && !pathname.getName().equals("shell.js") && !pathname.getName().equals("browser.js") && !pathname.getName().equals("template.js");
        }
    };

    public static String getStackTrace(Throwable t) {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(bytes));
        return new String(bytes.toByteArray());
    }

    private static void runFileIfExists(Context cx, Scriptable global, File f) {
        if (f.isFile()) {
            Main.processFile(cx, global, f.getPath());
        }
    }

    private static void callStop(Thread t) {
        t.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void run(final ShellContextFactory shellContextFactory, final File jsFile, Parameters parameters, final Status status) throws Exception {
        String s;
        final Global global = new Global();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintStream p = new PrintStream(out);
        global.setOut(p);
        global.setErr(p);
        global.defineFunctionProperties(new String[]{"options"}, ShellTest.class, 7);
        final TestState testState = new TestState();
        if (jsFile.getName().endsWith("-n.js")) {
            status.setNegative();
        }
        final Throwable[] thrown = new Throwable[1];
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block18: {
                    try {
                        shellContextFactory.call(new ContextAction(){

                            @Override
                            public Object run(Context cx) {
                                status.running(jsFile);
                                testState.errors = new ErrorReporterWrapper(cx.getErrorReporter());
                                cx.setErrorReporter(testState.errors);
                                global.init(cx);
                                try {
                                    ShellTest.runFileIfExists(cx, global, new File(jsFile.getParentFile().getParentFile().getParentFile(), "shell.js"));
                                    ShellTest.runFileIfExists(cx, global, new File(jsFile.getParentFile().getParentFile(), "shell.js"));
                                    ShellTest.runFileIfExists(cx, global, new File(jsFile.getParentFile(), "shell.js"));
                                    ShellTest.runFileIfExists(cx, global, jsFile);
                                    status.hadErrors(jsFile, testState.errors.errors.toArray(new Status.JsError[0]));
                                }
                                catch (ThreadDeath threadDeath) {
                                }
                                catch (Throwable t) {
                                    status.threw(t);
                                }
                                return null;
                            }
                        });
                    }
                    catch (Error t) {
                        thrown[0] = t;
                        TestState testState3 = testState;
                        synchronized (testState3) {
                            testState.finished = true;
                            break block18;
                        }
                    }
                    catch (RuntimeException t) {
                        TestState testState4;
                        try {
                            thrown[0] = t;
                            testState4 = testState;
                        }
                        catch (Throwable throwable) {
                            TestState testState2 = testState;
                            synchronized (testState2) {
                                testState.finished = true;
                            }
                            throw throwable;
                        }
                        synchronized (testState4) {
                            testState.finished = true;
                            break block18;
                        }
                    }
                    TestState testState5 = testState;
                    synchronized (testState5) {
                        testState.finished = true;
                    }
                }
            }
        }, jsFile.getPath());
        t.setDaemon(true);
        t.start();
        t.join(parameters.getTimeoutMilliseconds());
        TestState testState2 = testState;
        synchronized (testState2) {
            if (!testState.finished) {
                ShellTest.callStop(t);
                status.timedOut();
            }
        }
        int expectedExitCode = 0;
        p.flush();
        status.outputWas(new String(out.toByteArray()));
        BufferedReader r = new BufferedReader(new InputStreamReader(new ByteArrayInputStream(out.toByteArray())));
        String failures = "";
        while ((s = r.readLine()) != null) {
            int expex;
            if (s.indexOf("FAILED!") != -1) {
                failures = String.valueOf(failures) + s + '\n';
            }
            if ((expex = s.indexOf("EXPECT EXIT CODE ")) == -1) continue;
            expectedExitCode = s.charAt(expex + "EXPECT EXIT CODE ".length()) - 48;
        }
        if (thrown[0] != null) {
            status.threw(thrown[0]);
        }
        status.exitCodesWere(expectedExitCode, testState.exitCode);
        if (failures != "") {
            status.failed(failures);
        }
    }

    public static String options() {
        return "";
    }

    private static class ErrorReporterWrapper
    implements ErrorReporter {
        private ErrorReporter original;
        private ArrayList<Status.JsError> errors = new ArrayList();

        ErrorReporterWrapper(ErrorReporter original) {
            this.original = original;
        }

        private void addError(String string, String string0, int i, String string1, int i0) {
            this.errors.add(new Status.JsError(string, string0, i, string1, i0));
        }

        @Override
        public void warning(String string, String string0, int i, String string1, int i0) {
            this.original.warning(string, string0, i, string1, i0);
        }

        @Override
        public EvaluatorException runtimeError(String string, String string0, int i, String string1, int i0) {
            return this.original.runtimeError(string, string0, i, string1, i0);
        }

        @Override
        public void error(String string, String string0, int i, String string1, int i0) {
            this.addError(string, string0, i, string1, i0);
        }
    }

    public static abstract class Parameters {
        public abstract int getTimeoutMilliseconds();
    }

    public static abstract class Status {
        private boolean negative;

        public final void setNegative() {
            this.negative = true;
        }

        public final boolean isNegative() {
            return this.negative;
        }

        public final void hadErrors(JsError[] errors) {
            if (!this.negative && errors.length > 0) {
                this.failed("JavaScript errors:\n" + JsError.toString(errors));
            } else if (this.negative && errors.length == 0) {
                this.failed("Should have produced runtime error.");
            }
        }

        public final void hadErrors(File jsFile, JsError[] errors) {
            if (!this.negative && errors.length > 0) {
                this.failed("JavaScript errors in " + jsFile + ":\n" + JsError.toString(errors));
            } else if (this.negative && errors.length == 0) {
                this.failed("Should have produced runtime error in " + jsFile + ".");
            }
        }

        public abstract void running(File var1);

        public abstract void failed(String var1);

        public abstract void threw(Throwable var1);

        public abstract void timedOut();

        public abstract void exitCodesWere(int var1, int var2);

        public abstract void outputWas(String var1);

        static Status compose(final Status[] array) {
            return new Status(){

                @Override
                public void running(File file) {
                    int i = 0;
                    while (i < array.length) {
                        array[i].running(file);
                        ++i;
                    }
                }

                @Override
                public void threw(Throwable t) {
                    int i = 0;
                    while (i < array.length) {
                        array[i].threw(t);
                        ++i;
                    }
                }

                @Override
                public void failed(String s) {
                    int i = 0;
                    while (i < array.length) {
                        array[i].failed(s);
                        ++i;
                    }
                }

                @Override
                public void exitCodesWere(int expected, int actual) {
                    int i = 0;
                    while (i < array.length) {
                        array[i].exitCodesWere(expected, actual);
                        ++i;
                    }
                }

                @Override
                public void outputWas(String s) {
                    int i = 0;
                    while (i < array.length) {
                        array[i].outputWas(s);
                        ++i;
                    }
                }

                @Override
                public void timedOut() {
                    int i = 0;
                    while (i < array.length) {
                        array[i].timedOut();
                        ++i;
                    }
                }
            };
        }

        static class JsError {
            private String message;
            private String sourceName;
            private int line;
            private String lineSource;
            private int lineOffset;

            static String toString(JsError[] e) {
                String rv = "";
                int i = 0;
                while (i < e.length) {
                    rv = String.valueOf(rv) + e[i].toString();
                    if (i + 1 != e.length) {
                        rv = String.valueOf(rv) + "\n";
                    }
                    ++i;
                }
                return rv;
            }

            JsError(String message, String sourceName, int line, String lineSource, int lineOffset) {
                this.message = message;
                this.sourceName = sourceName;
                this.line = line;
                this.lineSource = lineSource;
                this.lineOffset = lineOffset;
            }

            public String toString() {
                String locationLine = "";
                if (this.sourceName != null) {
                    locationLine = String.valueOf(locationLine) + this.sourceName + ":";
                }
                if (this.line != 0) {
                    locationLine = String.valueOf(locationLine) + this.line + ": ";
                }
                locationLine = String.valueOf(locationLine) + this.message;
                String sourceLine = this.lineSource;
                String errCaret = null;
                if (this.lineSource != null) {
                    errCaret = "";
                    int i = 0;
                    while (i < this.lineSource.length()) {
                        char c = this.lineSource.charAt(i);
                        if (i < this.lineOffset - 1) {
                            errCaret = c == '\t' ? String.valueOf(errCaret) + "\t" : String.valueOf(errCaret) + " ";
                        } else if (i == this.lineOffset - 1) {
                            errCaret = String.valueOf(errCaret) + "^";
                        }
                        ++i;
                    }
                }
                String rv = locationLine;
                if (sourceLine != null) {
                    rv = String.valueOf(rv) + "\n" + sourceLine;
                }
                if (errCaret != null) {
                    rv = String.valueOf(rv) + "\n" + errCaret;
                }
                return rv;
            }

            String getMessage() {
                return this.message;
            }

            String getSourceName() {
                return this.sourceName;
            }

            int getLine() {
                return this.line;
            }

            String getLineSource() {
                return this.lineSource;
            }

            int getLineOffset() {
                return this.lineOffset;
            }
        }
    }

    private static class TestState {
        boolean finished;
        ErrorReporterWrapper errors;
        int exitCode = 0;

        private TestState() {
        }
    }
}

