/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.drivers;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JsTestsBase
extends TestCase {
    private int optimizationLevel;

    public void setOptimizationLevel(int level) {
        this.optimizationLevel = level;
    }

    public void runJsTest(Context cx, Scriptable shared, String name, String source) {
        Object result;
        Scriptable scope = cx.newObject(shared);
        scope.setPrototype(shared);
        System.out.print(String.valueOf(name) + ": ");
        try {
            result = cx.evaluateString(scope, source, "jstest input", 1, null);
        }
        catch (RuntimeException e) {
            System.out.println("FAILED");
            throw e;
        }
        JsTestsBase.assertTrue((result != null ? 1 : 0) != 0);
        JsTestsBase.assertTrue((boolean)"success".equals(result));
        System.out.println("passed");
    }

    public void runJsTests(File[] tests) throws IOException {
        ContextFactory factory = ContextFactory.getGlobal();
        Context cx = factory.enterContext();
        try {
            cx.setOptimizationLevel(this.optimizationLevel);
            ScriptableObject shared = cx.initStandardObjects();
            File[] fileArray = tests;
            int n = tests.length;
            int n2 = 0;
            while (n2 < n) {
                File f = fileArray[n2];
                int length = (int)f.length();
                char[] buf = new char[length];
                new FileReader(f).read(buf, 0, length);
                String session = new String(buf);
                this.runJsTest(cx, shared, f.getName(), session);
                ++n2;
            }
        }
        finally {
            Context.exit();
        }
    }
}

