/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.drivers;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mozilla.javascript.drivers.ShellTest;
import org.mozilla.javascript.drivers.TestUtils;
import org.mozilla.javascript.tools.shell.ShellContextFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JsDriver {
    private JsDriver() {
    }

    private static String join(String[] list) {
        String rv = "";
        int i = 0;
        while (i < list.length) {
            rv = String.valueOf(rv) + list[i];
            if (i + 1 != list.length) {
                rv = String.valueOf(rv) + ",";
            }
            ++i;
        }
        return rv;
    }

    private static boolean setContent(Element node, String id, String content) {
        if (node.getAttribute("id").equals(id)) {
            node.setTextContent(String.valueOf(node.getTextContent()) + "\n" + content);
            return true;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element e;
            boolean rv;
            if (children.item(i) instanceof Element && (rv = JsDriver.setContent(e = (Element)children.item(i), id, content))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static Element getElementById(Element node, String id) {
        if (node.getAttribute("id").equals(id)) {
            return node;
        }
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Element rv;
            if (children.item(i) instanceof Element && (rv = JsDriver.getElementById((Element)children.item(i), id)) != null) {
                return rv;
            }
            ++i;
        }
        return null;
    }

    private static String newlineLineEndings(String s) {
        StringBuffer rv = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            if (s.charAt(i) == '\r') {
                if (i + 1 >= s.length() || s.charAt(i + 1) != '\n') {
                    rv.append('\n');
                }
            } else {
                rv.append(s.charAt(i));
            }
            ++i;
        }
        return rv.toString();
    }

    void run(Arguments arguments) throws Throwable {
        if (arguments.help()) {
            System.out.println("See mozilla/js/tests/README-jsDriver.html; note that some options are not supported.");
            System.out.println("Consult the Java source code at testsrc/org/mozilla/javascript/JsDriver.java for details.");
            System.exit(0);
        }
        ShellContextFactory factory = new ShellContextFactory();
        factory.setOptimizationLevel(arguments.getOptimizationLevel());
        factory.setStrictMode(arguments.isStrict());
        File path = arguments.getTestsPath();
        if (path == null) {
            path = new File("../tests");
        }
        if (!path.exists()) {
            throw new RuntimeException("JavaScript tests not found at " + path.getCanonicalPath());
        }
        Tests tests = new Tests(path, arguments.getTestList(), arguments.getSkipList());
        Tests.Script[] all = tests.getFiles();
        arguments.getConsole().println("Running " + all.length + " tests.");
        Results results = new Results(factory, arguments, arguments.trace());
        results.start();
        int i = 0;
        while (i < all.length) {
            results.run(all[i], new ShellTestParameters(arguments.getTimeout()));
            ++i;
        }
        results.finish();
    }

    public static void main(Arguments arguments) throws Throwable {
        JsDriver driver = new JsDriver();
        driver.run(arguments);
    }

    public static void main(String[] args) throws Throwable {
        ArrayList<String> arguments = new ArrayList<String>();
        arguments.addAll(Arrays.asList(args));
        Arguments clArguments = new Arguments();
        clArguments.process(arguments);
        JsDriver.main(clArguments);
    }

    private static class Arguments {
        private ArrayList<Option> options = new ArrayList();
        private Option bugUrl = new Option("b", "bugurl", false, false, "http://bugzilla.mozilla.org/show_bug.cgi?id=");
        private Option optimizationLevel = new Option("o", "optimization", false, false, "-1");
        private Option strict = new Option(null, "strict", false, true, null);
        private Option outputFile = new Option("f", "file", false, false, null);
        private Option help = new Option("h", "help", false, true, null);
        private Option logFailuresToConsole = new Option("k", "confail", false, true, null);
        private Option testList = new Option("l", "list", true, false, null);
        private Option skipList = new Option("L", "neglist", true, false, null);
        private Option testsPath = new Option("p", "testpath", false, false, null);
        private Option trace = new Option("t", "trace", false, true, null);
        private Option lxrUrl = new Option("u", "lxrurl", false, false, "http://lxr.mozilla.org/mozilla/source/js/tests/");
        private Option timeout = new Option(null, "timeout", false, false, "60000");
        private Console console = new Console();

        private Arguments() {
        }

        public String getBugUrl() {
            return this.bugUrl.getValue();
        }

        public int getOptimizationLevel() {
            return this.optimizationLevel.getInt();
        }

        public boolean isStrict() {
            return this.strict.getSwitch();
        }

        public File getOutputFile() {
            return this.outputFile.getFile();
        }

        public boolean help() {
            return this.help.getSwitch();
        }

        public boolean logFailuresToConsole() {
            return this.logFailuresToConsole.getSwitch();
        }

        public String[] getTestList() {
            return this.testList.getValues();
        }

        public String[] getSkipList() {
            return this.skipList.getValues();
        }

        public File getTestsPath() {
            return this.testsPath.getFile();
        }

        public boolean trace() {
            return this.trace.getSwitch();
        }

        public String getLxrUrl() {
            return this.lxrUrl.getValue();
        }

        public int getTimeout() {
            return this.timeout.getInt();
        }

        public Console getConsole() {
            return this.console;
        }

        void process(List<String> arguments) {
            while (arguments.size() > 0) {
                String option = arguments.get(0);
                if (option.startsWith("--")) {
                    if (option.indexOf("=") != -1) {
                        arguments.set(0, option.substring(option.indexOf("=")));
                        arguments.add(1, option.substring(option.indexOf("=") + 1));
                    }
                } else if (option.startsWith("-") && option.length() > 2) {
                    int i = 2;
                    while (i < option.length()) {
                        arguments.add(1, "-" + option.substring(i, i + 1));
                        ++i;
                    }
                    arguments.set(0, option.substring(0, 2));
                }
                int lengthBefore = arguments.size();
                int i = 0;
                while (i < this.options.size()) {
                    if (arguments.size() > 0) {
                        this.options.get(i).process(arguments);
                    }
                    ++i;
                }
                if (arguments.size() != lengthBefore) continue;
                System.err.println("WARNING: ignoring unrecognized option " + arguments.remove(0));
            }
        }

        public static class Console {
            public void print(String message) {
                System.out.print(message);
            }

            public void println(String message) {
                System.out.println(message);
            }
        }

        private class Option {
            private String letterOption;
            private String wordOption;
            private boolean array;
            private boolean flag;
            private boolean ignored;
            private ArrayList<String> values = new ArrayList();

            Option(String letterOption, String wordOption, boolean array, boolean flag, String unspecified) {
                this.letterOption = letterOption;
                this.wordOption = wordOption;
                this.flag = flag;
                this.array = array;
                if (!flag && !array) {
                    this.values.add(unspecified);
                }
                Arguments.this.options.add(this);
            }

            Option ignored() {
                this.ignored = true;
                return this;
            }

            int getInt() {
                return Integer.parseInt(this.getValue());
            }

            String getValue() {
                return this.values.get(0);
            }

            boolean getSwitch() {
                return this.values.size() > 0;
            }

            File getFile() {
                if (this.getValue() == null) {
                    return null;
                }
                return new File(this.getValue());
            }

            String[] getValues() {
                return this.values.toArray(new String[0]);
            }

            void process(List<String> arguments) {
                String dashLetter;
                String option = arguments.get(0);
                String string = dashLetter = this.letterOption == null ? null : "-" + this.letterOption;
                if (option.equals(dashLetter) || option.equals("--" + this.wordOption)) {
                    arguments.remove(0);
                    if (this.flag) {
                        this.values.add(0, null);
                    } else if (this.array) {
                        while (arguments.size() > 0 && !arguments.get(0).startsWith("-")) {
                            this.values.add(arguments.remove(0));
                        }
                    } else {
                        this.values.set(0, arguments.remove(0));
                    }
                    if (this.ignored) {
                        System.err.println("WARNING: " + option + " is ignored in the Java version of the test driver.");
                    }
                }
            }
        }
    }

    private static class ConsoleStatus
    extends ShellTest.Status {
        private File jsFile;
        private Arguments.Console console;
        private boolean trace;
        private boolean failed;

        ConsoleStatus(Arguments.Console console, boolean trace) {
            this.console = console;
            this.trace = trace;
        }

        @Override
        public void running(File jsFile) {
            try {
                this.console.println("Running: " + jsFile.getCanonicalPath());
                this.jsFile = jsFile;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public void failed(String s) {
            this.console.println("Failed: " + this.jsFile + ": " + s);
            this.failed = true;
        }

        @Override
        public void threw(Throwable t) {
            this.console.println("Failed: " + this.jsFile + " with exception.");
            this.console.println(ShellTest.getStackTrace(t));
            this.failed = true;
        }

        @Override
        public void timedOut() {
            this.console.println("Failed: " + this.jsFile + ": timed out.");
            this.failed = true;
        }

        @Override
        public void exitCodesWere(int expected, int actual) {
            if (expected != actual) {
                this.console.println("Failed: " + this.jsFile + " expected " + expected + " actual " + actual);
                this.failed = true;
            }
        }

        @Override
        public void outputWas(String s) {
            if (!this.failed) {
                this.console.println("Passed: " + this.jsFile);
                if (this.trace) {
                    this.console.println(s);
                }
            }
        }
    }

    private static class HtmlStatus
    extends ShellTest.Status {
        private String testPath;
        private String bugUrl;
        private String lxrUrl;
        private Document html;
        private Element failureHtml;
        private boolean failed;
        private String output;

        HtmlStatus(String lxrUrl, String bugUrl, String testPath, Document html, Element failureHtml) {
            this.testPath = testPath;
            this.bugUrl = bugUrl;
            this.lxrUrl = lxrUrl;
            this.html = html;
            this.failureHtml = failureHtml;
        }

        @Override
        public void running(File file) {
        }

        @Override
        public void failed(String s) {
            this.failed = true;
            JsDriver.setContent(this.failureHtml, "failureDetails.reason", "Failure reason: \n" + s);
        }

        @Override
        public void exitCodesWere(int expected, int actual) {
            if (expected != actual) {
                this.failed = true;
                JsDriver.setContent(this.failureHtml, "failureDetails.reason", "expected exit code " + expected + " but got " + actual);
            }
        }

        @Override
        public void threw(Throwable e) {
            this.failed = true;
            JsDriver.setContent(this.failureHtml, "failureDetails.reason", "Threw Java exception:\n" + JsDriver.newlineLineEndings(ShellTest.getStackTrace(e)));
        }

        @Override
        public void timedOut() {
            this.failed = true;
            JsDriver.setContent(this.failureHtml, "failureDetails.reason", "Timed out.");
        }

        @Override
        public void outputWas(String s) {
            this.output = s;
        }

        private String getLinesStartingWith(String prefix) {
            BufferedReader r = new BufferedReader(new StringReader(this.output));
            String line = null;
            String rv = "";
            try {
                while ((line = r.readLine()) != null) {
                    if (!line.startsWith(prefix)) continue;
                    if (rv.length() > 0) {
                        rv = String.valueOf(rv) + "\n";
                    }
                    rv = String.valueOf(rv) + line;
                }
                return rv;
            }
            catch (IOException e) {
                throw new RuntimeException("Can't happen.");
            }
        }

        boolean failed() {
            return this.failed;
        }

        void finish() {
            if (this.failed) {
                JsDriver.getElementById(this.failureHtml, "failureDetails.status").setTextContent(this.getLinesStartingWith("STATUS:"));
                String bn = this.getLinesStartingWith("BUGNUMBER:");
                Element bnlink = JsDriver.getElementById(this.failureHtml, "failureDetails.bug.href");
                if (bn.length() > 0) {
                    String number = bn.substring("BUGNUMBER: ".length());
                    if (!number.equals("none")) {
                        bnlink.setAttribute("href", String.valueOf(this.bugUrl) + number);
                        JsDriver.getElementById(bnlink, "failureDetails.bug.number").setTextContent(number);
                    } else {
                        bnlink.getParentNode().removeChild(bnlink);
                    }
                } else {
                    bnlink.getParentNode().removeChild(bnlink);
                }
                JsDriver.getElementById(this.failureHtml, "failureDetails.lxr").setAttribute("href", String.valueOf(this.lxrUrl) + this.testPath);
                JsDriver.getElementById(this.failureHtml, "failureDetails.lxr.text").setTextContent(this.testPath);
                JsDriver.getElementById(this.html.getDocumentElement(), "retestList.text").setTextContent(String.valueOf(JsDriver.getElementById(this.html.getDocumentElement(), "retestList.text").getTextContent()) + this.testPath + "\n");
                JsDriver.getElementById(this.html.getDocumentElement(), "failureDetails").appendChild(this.failureHtml);
            }
        }
    }

    private static class Results {
        private ShellContextFactory factory;
        private Arguments arguments;
        private File output;
        private boolean trace;
        private Document html;
        private Element failureHtml;
        private Document xml;
        private Date start;
        private int tests;
        private int failures;

        Results(ShellContextFactory factory, Arguments arguments, boolean trace) {
            this.factory = factory;
            this.arguments = arguments;
            File output = arguments.getOutputFile();
            if (output == null) {
                output = new File("rhino-test-results." + new SimpleDateFormat("yyyy.MM.dd.HH.mm.ss").format(new Date()) + ".html");
            }
            this.output = output;
            this.trace = trace;
        }

        private Document parse(InputStream in) {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                DocumentBuilder dom = factory.newDocumentBuilder();
                return dom.parse(in);
            }
            catch (Throwable t) {
                throw new RuntimeException("Parser failure", t);
            }
        }

        private Document getTemplate() {
            return this.parse(this.getClass().getResourceAsStream("results.html"));
        }

        private void write(Document template, boolean xml) {
            try {
                File output = this.output;
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer xform = factory.newTransformer();
                if (xml) {
                    xform.setOutputProperty("method", "xml");
                    xform.setOutputProperty("omit-xml-declaration", "yes");
                    output = new File(String.valueOf(output.getCanonicalPath()) + ".xml");
                }
                xform.transform(new DOMSource(template), new StreamResult(new FileOutputStream(output)));
            }
            catch (IOException e) {
                this.arguments.getConsole().println("Could not write results file to " + this.output + ": ");
                e.printStackTrace(System.err);
            }
            catch (TransformerConfigurationException e) {
                throw new RuntimeException("Parser failure", e);
            }
            catch (TransformerException e) {
                throw new RuntimeException("Parser failure", e);
            }
        }

        void start() {
            this.html = this.getTemplate();
            this.failureHtml = JsDriver.getElementById(this.html.getDocumentElement(), "failureDetails.prototype");
            if (this.failureHtml == null) {
                try {
                    TransformerFactory.newInstance().newTransformer().transform(new DOMSource(this.html), new StreamResult(System.err));
                }
                catch (Throwable t) {
                    throw new RuntimeException(t);
                }
                throw new RuntimeException("No");
            }
            this.failureHtml.getParentNode().removeChild(this.failureHtml);
            try {
                this.xml = DocumentBuilderFactory.newInstance().newDocumentBuilder().getDOMImplementation().createDocument(null, "results", null);
                this.xml.getDocumentElement().setAttribute("timestamp", String.valueOf(new Date().getTime()));
                this.xml.getDocumentElement().setAttribute("optimization", String.valueOf(this.arguments.getOptimizationLevel()));
                this.xml.getDocumentElement().setAttribute("strict", String.valueOf(this.arguments.isStrict()));
                this.xml.getDocumentElement().setAttribute("timeout", String.valueOf(this.arguments.getTimeout()));
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException(e);
            }
            this.start = new Date();
        }

        void run(Tests.Script script, ShellTest.Parameters parameters) {
            String path = script.getPath();
            File test = script.getFile();
            ConsoleStatus cStatus = new ConsoleStatus(this.arguments.getConsole(), this.trace);
            HtmlStatus hStatus = new HtmlStatus(this.arguments.getLxrUrl(), this.arguments.getBugUrl(), path, this.html, (Element)this.failureHtml.cloneNode(true));
            XmlStatus xStatus = new XmlStatus(path, this.xml.getDocumentElement());
            ShellTest.Status status = ShellTest.Status.compose(new ShellTest.Status[]{cStatus, hStatus, xStatus});
            try {
                ShellTest.run(this.factory, test, parameters, status);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            ++this.tests;
            if (hStatus.failed()) {
                ++this.failures;
            }
            hStatus.finish();
        }

        private void set(Document document, String id, String value) {
            JsDriver.getElementById(document.getDocumentElement(), id).setTextContent(value);
        }

        void finish() {
            Date end = new Date();
            long elapsedMs = end.getTime() - this.start.getTime();
            this.set(this.html, "results.testlist", JsDriver.join(this.arguments.getTestList()));
            this.set(this.html, "results.skiplist", JsDriver.join(this.arguments.getSkipList()));
            String pct = new DecimalFormat("##0.00").format((double)this.failures / (double)this.tests * 100.0);
            this.set(this.html, "results.results", "Tests attempted: " + this.tests + " Failures: " + this.failures + " (" + pct + "%)");
            this.set(this.html, "results.platform", "java.home=" + System.getProperty("java.home") + "\n" + "java.version=" + System.getProperty("java.version") + "\n" + "os.name=" + System.getProperty("os.name"));
            this.set(this.html, "results.classpath", System.getProperty("java.class.path").replace(File.pathSeparatorChar, ' '));
            int elapsedSeconds = (int)(elapsedMs / 1000L);
            int elapsedMinutes = elapsedSeconds / 60;
            String elapsed = elapsedMinutes + " minutes, " + (elapsedSeconds %= 60) + " seconds";
            this.set(this.html, "results.elapsed", elapsed);
            this.set(this.html, "results.time", new SimpleDateFormat("MMMM d yyyy h:mm:ss aa").format(new Date()));
            this.write(this.html, false);
            this.write(this.xml, true);
        }
    }

    private static class ShellTestParameters
    extends ShellTest.Parameters {
        private int timeout;

        ShellTestParameters(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public int getTimeoutMilliseconds() {
            return this.timeout;
        }
    }

    private static class Tests {
        private File testDirectory;
        private String[] list;
        private String[] skip;

        Tests(File testDirectory, String[] list, String[] skip) throws IOException {
            this.testDirectory = testDirectory;
            this.list = this.getTestList(list);
            this.skip = this.getTestList(skip);
        }

        private String[] getTestList(String[] tests) throws IOException {
            ArrayList<String> list = new ArrayList<String>();
            int i = 0;
            while (i < tests.length) {
                if (tests[i].startsWith("@")) {
                    TestUtils.addTestsFromFile(tests[i].substring(1), list);
                } else {
                    list.add(tests[i]);
                }
                ++i;
            }
            return list.toArray(new String[0]);
        }

        private boolean matches(String path) {
            if (this.list.length == 0) {
                return true;
            }
            return TestUtils.matches(this.list, path);
        }

        private boolean excluded(String path) {
            if (this.skip.length == 0) {
                return false;
            }
            return TestUtils.matches(this.skip, path);
        }

        private void addFiles(List<Script> rv, String prefix, File directory) {
            File[] files = directory.listFiles();
            if (files == null) {
                throw new RuntimeException("files null for " + directory);
            }
            int i = 0;
            while (i < files.length) {
                String path = String.valueOf(prefix) + files[i].getName();
                if (ShellTest.DIRECTORY_FILTER.accept(files[i])) {
                    this.addFiles(rv, String.valueOf(path) + "/", files[i]);
                } else {
                    boolean isTopLevel;
                    boolean bl = isTopLevel = prefix.length() == 0;
                    if (ShellTest.TEST_FILTER.accept(files[i]) && this.matches(path) && !this.excluded(path) && !isTopLevel) {
                        rv.add(new Script(path, files[i]));
                    }
                }
                ++i;
            }
        }

        Script[] getFiles() {
            ArrayList<Script> rv = new ArrayList<Script>();
            this.addFiles(rv, "", this.testDirectory);
            return rv.toArray(new Script[0]);
        }

        static class Script {
            private String path;
            private File file;

            Script(String path, File file) {
                this.path = path;
                this.file = file;
            }

            String getPath() {
                return this.path;
            }

            File getFile() {
                return this.file;
            }
        }
    }

    private static class XmlStatus
    extends ShellTest.Status {
        private Element target;
        private Date start;

        XmlStatus(String path, Element root) {
            this.target = root.getOwnerDocument().createElement("test");
            this.target.setAttribute("path", path);
            root.appendChild(this.target);
        }

        @Override
        public void running(File file) {
            this.start = new Date();
        }

        private Element createElement(Element parent, String name) {
            Element rv = parent.getOwnerDocument().createElement(name);
            parent.appendChild(rv);
            return rv;
        }

        private void finish() {
            Date end = new Date();
            long elapsed = end.getTime() - this.start.getTime();
            this.target.setAttribute("elapsed", String.valueOf(elapsed));
        }

        private void setTextContent(Element e, String content) {
            e.setTextContent(JsDriver.newlineLineEndings(content));
        }

        @Override
        public void exitCodesWere(int expected, int actual) {
            this.finish();
            Element exit = this.createElement(this.target, "exit");
            exit.setAttribute("expected", String.valueOf(expected));
            exit.setAttribute("actual", String.valueOf(actual));
        }

        @Override
        public void timedOut() {
            this.finish();
            this.createElement(this.target, "timedOut");
        }

        @Override
        public void failed(String s) {
            this.finish();
            Element failed = this.createElement(this.target, "failed");
            this.setTextContent(failed, s);
        }

        @Override
        public void outputWas(String message) {
            this.finish();
            Element output = this.createElement(this.target, "output");
            this.setTextContent(output, message);
        }

        @Override
        public void threw(Throwable t) {
            this.finish();
            Element threw = this.createElement(this.target, "threw");
            this.setTextContent(threw, ShellTest.getStackTrace(t));
        }
    }
}

