/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module.provider;

import java.util.LinkedList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;

public class MultiModuleScriptProvider
implements ModuleScriptProvider {
    private final ModuleScriptProvider[] providers;

    public MultiModuleScriptProvider(Iterable<? extends ModuleScriptProvider> providers) {
        LinkedList<ModuleScriptProvider> l = new LinkedList<ModuleScriptProvider>();
        for (ModuleScriptProvider moduleScriptProvider : providers) {
            l.add(moduleScriptProvider);
        }
        this.providers = l.toArray(new ModuleScriptProvider[l.size()]);
    }

    @Override
    public ModuleScript getModuleScript(Context cx, String moduleId, Scriptable paths) throws Exception {
        ModuleScriptProvider[] moduleScriptProviderArray = this.providers;
        int n = this.providers.length;
        int n2 = 0;
        while (n2 < n) {
            ModuleScriptProvider provider = moduleScriptProviderArray[n2];
            ModuleScript script = provider.getModuleScript(cx, moduleId, paths);
            if (script != null) {
                return script;
            }
            ++n2;
        }
        return null;
    }
}

