/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module.provider;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.StringTokenizer;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.provider.ModuleSource;
import org.mozilla.javascript.commonjs.module.provider.ModuleSourceProvider;

public class ModuleSourceProviderBase
implements ModuleSourceProvider,
Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public ModuleSource getModuleSource(String moduleId, Scriptable paths, Object validator) throws IOException {
        if (!ModuleSourceProviderBase.isValidModuleIdentifier(moduleId)) {
            throw new IllegalArgumentException("ModuleScript ID '" + moduleId + "' is not valid");
        }
        if (!this.entityNeedsRevalidation(validator)) {
            return NOT_MODIFIED;
        }
        ModuleSource moduleSource = this.loadModuleSourceFromPrivilegedLocations(moduleId, validator);
        if (moduleSource != null) {
            return moduleSource;
        }
        if (paths != null && (moduleSource = this.loadModuleSourceFromPathArray(moduleId, paths, validator)) != null) {
            return moduleSource;
        }
        return this.loadModuleSourceFromFallbackLocations(moduleId, validator);
    }

    private ModuleSource loadModuleSourceFromPathArray(String moduleId, Scriptable paths, Object validator) throws IOException {
        long llength = ScriptRuntime.toUint32(ScriptableObject.getProperty(paths, "length"));
        int ilength = llength > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)llength;
        String relativeModuleUri = String.valueOf(moduleId) + ".js";
        int i = 0;
        while (i < ilength) {
            String path = ModuleSourceProviderBase.ensureTrailingSlash(ScriptableObject.getTypedProperty(paths, i, String.class));
            try {
                ModuleSource moduleSource = this.loadModuleSourceFromUri(new URI(path).resolve(relativeModuleUri), validator);
                if (moduleSource != null) {
                    return moduleSource;
                }
            }
            catch (URISyntaxException e) {
                throw new MalformedURLException(e.getMessage());
            }
            ++i;
        }
        return null;
    }

    private static String ensureTrailingSlash(String path) {
        return path.endsWith("/") ? path : path.concat("/");
    }

    protected boolean entityNeedsRevalidation(Object validator) {
        return true;
    }

    protected ModuleSource loadModuleSourceFromUri(URI uri, Object validator) throws IOException {
        return null;
    }

    protected ModuleSource loadModuleSourceFromPrivilegedLocations(String moduleId, Object validator) throws IOException {
        return null;
    }

    protected ModuleSource loadModuleSourceFromFallbackLocations(String moduleId, Object validator) throws IOException {
        return null;
    }

    public static boolean isValidModuleIdentifier(String moduleId) {
        if (moduleId == null || moduleId.length() == 0 || moduleId.charAt(0) == '/') {
            return false;
        }
        StringTokenizer tok = new StringTokenizer(moduleId, "/");
        while (tok.hasMoreTokens()) {
            String term = tok.nextToken();
            if (ModuleSourceProviderBase.isValidTerm(term)) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidTerm(String term) {
        int l = term.length();
        if (!Character.isJavaIdentifierStart(term.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < l) {
            if (!Character.isJavaIdentifierPart(term.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

