/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import junit.framework.TestCase;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.commonjs.module.provider.StrongCachingModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;

public class RequireTests
extends TestCase {
    public void testSandboxed() throws Exception {
        Context cx = this.createContext();
        Require require = this.getSandboxedRequire(cx);
        require.requireMain(cx, "testSandboxed");
        require.requireMain(cx, "testSandboxed");
        try {
            require.requireMain(cx, "blah");
            RequireTests.fail();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private Context createContext() {
        Context cx = Context.enter();
        cx.setOptimizationLevel(-1);
        return cx;
    }

    public void testNonSandboxed() throws Exception {
        Context cx = this.createContext();
        ScriptableObject scope = cx.initStandardObjects();
        Require require = this.getSandboxedRequire(cx, scope, false);
        String jsFile = ((Object)((Object)this)).getClass().getResource("testNonSandboxed.js").toExternalForm();
        ScriptableObject.putProperty((Scriptable)scope, "moduleUri", (Object)jsFile);
        require.requireMain(cx, "testNonSandboxed");
    }

    public void testVariousUsageErrors() throws Exception {
        this.testWithSandboxedRequire("testNoArgsRequire");
    }

    public void testRelativeId() throws Exception {
        Context cx = this.createContext();
        ScriptableObject scope = cx.initStandardObjects();
        Require require = this.getSandboxedRequire(cx, scope, false);
        require.install(scope);
        cx.evaluateReader(scope, this.getReader("testRelativeId.js"), "testRelativeId.js", 1, null);
    }

    public void testSetMainForAlreadyLoadedModule() throws Exception {
        Context cx = this.createContext();
        ScriptableObject scope = cx.initStandardObjects();
        Require require = this.getSandboxedRequire(cx, scope, false);
        require.install(scope);
        cx.evaluateReader(scope, this.getReader("testSetMainForAlreadyLoadedModule.js"), "testSetMainForAlreadyLoadedModule.js", 1, null);
        try {
            require.requireMain(cx, "assert");
            RequireTests.fail();
        }
        catch (IllegalStateException e) {
            RequireTests.assertEquals((String)e.getMessage(), (String)"Attempt to set main module after it was loaded");
        }
    }

    private Reader getReader(String name) {
        return new InputStreamReader(((Object)((Object)this)).getClass().getResourceAsStream(name));
    }

    private void testWithSandboxedRequire(String moduleId) throws Exception {
        Context cx = this.createContext();
        this.getSandboxedRequire(cx).requireMain(cx, moduleId);
    }

    private Require getSandboxedRequire(Context cx) throws URISyntaxException {
        return this.getSandboxedRequire(cx, cx.initStandardObjects(), true);
    }

    private Require getSandboxedRequire(Context cx, Scriptable scope, boolean sandboxed) throws URISyntaxException {
        return new Require(cx, cx.initStandardObjects(), new StrongCachingModuleScriptProvider(new UrlModuleSourceProvider(Collections.singleton(this.getDirectory()), null)), null, null, true);
    }

    private URI getDirectory() throws URISyntaxException {
        String jsFile = ((Object)((Object)this)).getClass().getResource("testSandboxed.js").toExternalForm();
        return new URI(jsFile.substring(0, jsFile.lastIndexOf(47) + 1));
    }
}

