/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.UniqueTag;
import org.mozilla.javascript.commonjs.module.ModuleScript;
import org.mozilla.javascript.commonjs.module.ModuleScriptProvider;

public class Require
extends ScriptableObject
implements Function {
    private static final long serialVersionUID = 1L;
    private final ModuleScriptProvider moduleScriptProvider;
    private final Scriptable nativeScope;
    private final Scriptable paths;
    private final boolean sandboxed;
    private final Script preExec;
    private final Script postExec;
    private String mainModuleId = null;
    private final Map<String, Scriptable> exportedModuleInterfaces = new ConcurrentHashMap<String, Scriptable>();
    private final Object loadLock = new Object();
    private static final ThreadLocal<Map<String, Scriptable>> loadingModuleInterfaces = new ThreadLocal();

    public Require(Context cx, Scriptable nativeScope, ModuleScriptProvider moduleScriptProvider, Script preExec, Script postExec, boolean sandboxed) {
        this.moduleScriptProvider = moduleScriptProvider;
        this.nativeScope = nativeScope;
        this.sandboxed = sandboxed;
        this.preExec = preExec;
        this.postExec = postExec;
        this.setPrototype(ScriptableObject.getFunctionPrototype(nativeScope));
        if (!sandboxed) {
            this.paths = cx.newArray(nativeScope, 0);
            Require.defineReadOnlyProperty(this, "paths", this.paths);
        } else {
            this.paths = null;
        }
    }

    public Scriptable requireMain(Context cx, String mainModuleId) {
        if (this.mainModuleId != null) {
            if (this.mainModuleId.equals(mainModuleId)) {
                return this.getExportedModuleInterface(cx, mainModuleId, false);
            }
            throw new IllegalStateException("main module already set to " + this.mainModuleId);
        }
        Scriptable mainExports = this.getExportedModuleInterface(cx, mainModuleId, true);
        this.mainModuleId = mainModuleId;
        return mainExports;
    }

    public void install(Scriptable scope) {
        ScriptableObject.putProperty(scope, "require", (Object)this);
    }

    @Override
    public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        if (args == null || args.length < 1) {
            throw ScriptRuntime.throwError(cx, scope, "require() needs one argument");
        }
        String id = (String)Context.jsToJava(args[0], String.class);
        String absoluteId = this.getAbsoluteId(cx, thisObj, id);
        return this.getExportedModuleInterface(cx, absoluteId, false);
    }

    private String getAbsoluteId(Context cx, Scriptable scope, String id) {
        if (id.startsWith("./") || id.startsWith("../")) {
            String moduleId = Require.getModuleId(scope);
            if (moduleId == null) {
                throw ScriptRuntime.throwError(cx, scope, "Can't resolve relative module ID " + id + " when require() is used outside of a module");
            }
            return Require.resolveRelativeId(Require.getParentDirectory(moduleId), id);
        }
        return id;
    }

    @Override
    public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
        throw ScriptRuntime.throwError(cx, scope, "require() can not be invoked as a constructor");
    }

    private static String resolveRelativeId(String directory, String id) {
        if (id.startsWith("./")) {
            return Require.resolveRelativeId(directory, id.substring(2));
        }
        if (id.startsWith("../")) {
            return Require.resolveRelativeId(Require.getParentDirectory(directory), id.substring(3));
        }
        return "".equals(directory) ? id : String.valueOf(directory) + "/" + id;
    }

    private static String getModuleId(Scriptable scope) {
        Object module = ScriptableObject.getProperty(scope, "module");
        if (!(module instanceof Scriptable)) {
            return null;
        }
        Object id = ScriptableObject.getProperty((Scriptable)module, "id");
        if (id == UniqueTag.NOT_FOUND || id == null) {
            return null;
        }
        return String.valueOf(Context.jsToJava(id, String.class));
    }

    private static String getParentDirectory(String path) {
        int i = path.lastIndexOf(47);
        return i == -1 ? "" : path.substring(0, i);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Scriptable getExportedModuleInterface(Context cx, String id, boolean isMain) {
        Scriptable exports = this.exportedModuleInterfaces.get(id);
        if (exports != null) {
            if (isMain) {
                throw new IllegalStateException("Attempt to set main module after it was loaded");
            }
            return exports;
        }
        Map<String, Scriptable> threadLoadingModules = loadingModuleInterfaces.get();
        if (threadLoadingModules != null && (exports = threadLoadingModules.get(id)) != null) {
            return exports;
        }
        Object object = this.loadLock;
        synchronized (object) {
            boolean outermostLocked;
            exports = this.exportedModuleInterfaces.get(id);
            if (exports != null) {
                return exports;
            }
            ModuleScript moduleScript = this.getModule(cx, id);
            exports = cx.newObject(this.nativeScope);
            boolean bl = outermostLocked = threadLoadingModules == null;
            if (outermostLocked) {
                threadLoadingModules = new HashMap<String, Scriptable>();
                loadingModuleInterfaces.set(threadLoadingModules);
            }
            threadLoadingModules.put(id, exports);
            try {
                try {
                    this.executeModuleScript(cx, id, exports, moduleScript, isMain);
                }
                catch (RuntimeException e) {
                    threadLoadingModules.remove(id);
                    throw e;
                }
            }
            finally {
                if (outermostLocked) {
                    this.exportedModuleInterfaces.putAll(threadLoadingModules);
                    loadingModuleInterfaces.set(null);
                }
            }
        }
        return exports;
    }

    private void executeModuleScript(Context cx, String id, Scriptable exports, ModuleScript moduleScript, boolean isMain) {
        String uri;
        ScriptableObject moduleObject = (ScriptableObject)cx.newObject(this.nativeScope);
        Require.defineReadOnlyProperty(moduleObject, "id", id);
        if (!this.sandboxed && (uri = moduleScript.getUri()) != null) {
            Require.defineReadOnlyProperty(moduleObject, "uri", uri);
        }
        Scriptable executionScope = cx.newObject(this.nativeScope);
        ScriptableObject.putProperty(executionScope, "exports", (Object)exports);
        ScriptableObject.putProperty(executionScope, "module", (Object)moduleObject);
        this.install(executionScope);
        executionScope.setPrototype(this.nativeScope);
        if (isMain) {
            Require.defineReadOnlyProperty(this, "main", moduleObject);
        }
        Require.executeOptionalScript(this.preExec, cx, executionScope);
        moduleScript.getScript().exec(cx, executionScope);
        Require.executeOptionalScript(this.postExec, cx, executionScope);
    }

    private static void executeOptionalScript(Script script, Context cx, Scriptable executionScope) {
        if (script != null) {
            script.exec(cx, executionScope);
        }
    }

    private static void defineReadOnlyProperty(ScriptableObject obj, String name, Object value) {
        ScriptableObject.putProperty((Scriptable)obj, name, value);
        obj.setAttributes(name, 5);
    }

    private ModuleScript getModule(Context cx, String id) {
        try {
            ModuleScript moduleScript = this.moduleScriptProvider.getModuleScript(cx, id, this.paths);
            if (moduleScript == null) {
                throw ScriptRuntime.throwError(cx, this.nativeScope, "Module " + id + " not found.");
            }
            return moduleScript;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw Context.throwAsScriptRuntimeEx(e);
        }
    }

    @Override
    public String getClassName() {
        return "Function";
    }
}

