/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.commonjs.module;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Collections;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.commonjs.module.Require;
import org.mozilla.javascript.commonjs.module.provider.StrongCachingModuleScriptProvider;
import org.mozilla.javascript.commonjs.module.provider.UrlModuleSourceProvider;

public class ComplianceTests
extends TestCase {
    public static TestSuite suite() throws Exception {
        TestSuite suite = new TestSuite("InteroperableJS tests");
        URL url = ComplianceTests.class.getResource("1.0");
        String path = URLDecoder.decode(url.getFile(), System.getProperty("file.encoding"));
        File testsDir = new File(path);
        ComplianceTests.addTests(suite, testsDir, "");
        return suite;
    }

    private static void addTests(TestSuite suite, File testDir, String name) {
        File programFile = new File(testDir, "program.js");
        if (programFile.isFile()) {
            suite.addTest(ComplianceTests.createTest(testDir, name));
        } else {
            File[] files;
            File[] fileArray = files = testDir.listFiles();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.isDirectory()) {
                    ComplianceTests.addTests(suite, file, String.valueOf(name) + "/" + file.getName());
                }
                ++n2;
            }
        }
    }

    private static Test createTest(final File testDir, String name) {
        return new TestCase(name){

            public int countTestCases() {
                return 1;
            }

            public void runBare() throws Throwable {
                Context cx = Context.enter();
                try {
                    cx.setOptimizationLevel(-1);
                    ScriptableObject scope = cx.initStandardObjects();
                    ScriptableObject.putProperty((Scriptable)scope, "print", (Object)new Print(scope));
                    ComplianceTests.createRequire(testDir, cx, scope).requireMain(cx, "program");
                }
                finally {
                    Context.exit();
                }
            }
        };
    }

    private static Require createRequire(File dir, Context cx, Scriptable scope) throws URISyntaxException {
        return new Require(cx, scope, new StrongCachingModuleScriptProvider(new UrlModuleSourceProvider(Collections.singleton(new URI("file:" + dir.getAbsolutePath().replace(File.separatorChar, '/') + "/")), Collections.singleton(new URI(String.valueOf(ComplianceTests.class.getResource(".").toExternalForm()) + "/")))), null, null, false);
    }

    private static class Print
    extends ScriptableObject
    implements Function {
        Print(Scriptable scope) {
            this.setPrototype(ScriptableObject.getFunctionPrototype(scope));
        }

        @Override
        public Object call(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
            if (args.length > 1 && "fail".equals(args[1])) {
                throw new AssertionFailedError(String.valueOf(args[0]));
            }
            return null;
        }

        @Override
        public Scriptable construct(Context cx, Scriptable scope, Object[] args) {
            throw new AssertionFailedError("Shouldn't be invoked as constructor");
        }

        @Override
        public String getClassName() {
            return "Function";
        }
    }
}

