/*
 * Decompiled with CFR 0.152.
 */
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class Shell
extends ScriptableObject {
    private static final long serialVersionUID = -5638074146250193112L;
    private boolean quitting;

    @Override
    public String getClassName() {
        return "global";
    }

    public static void main(String[] args) {
        Context cx = Context.enter();
        try {
            Object[] array;
            Shell shell = new Shell();
            cx.initStandardObjects(shell);
            String[] names = new String[]{"print", "quit", "version", "load", "help"};
            shell.defineFunctionProperties(names, Shell.class, 2);
            args = Shell.processOptions(cx, args);
            if (args.length == 0) {
                array = new Object[]{};
            } else {
                int length = args.length - 1;
                array = new Object[length];
                System.arraycopy(args, 1, array, 0, length);
            }
            Scriptable argsObj = cx.newArray((Scriptable)shell, array);
            shell.defineProperty("arguments", argsObj, 2);
            shell.processSource(cx, args.length == 0 ? null : args[0]);
        }
        finally {
            Context.exit();
        }
    }

    public static String[] processOptions(Context cx, String[] args) {
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (!arg.startsWith("-")) {
                String[] result = new String[args.length - i];
                int j = i;
                while (j < args.length) {
                    result[j - i] = args[j];
                    ++j;
                }
                return result;
            }
            if (arg.equals("-version")) {
                double d;
                if (++i == args.length) {
                    Shell.usage(arg);
                }
                if ((d = Context.toNumber(args[i])) != d) {
                    Shell.usage(arg);
                }
                cx.setLanguageVersion((int)d);
            } else {
                Shell.usage(arg);
            }
            ++i;
        }
        return new String[0];
    }

    private static void usage(String s) {
        Shell.p("Didn't understand \"" + s + "\".");
        Shell.p("Valid arguments are:");
        Shell.p("-version 100|110|120|130|140|150|160|170");
        System.exit(1);
    }

    public void help() {
        Shell.p("");
        Shell.p("Command                Description");
        Shell.p("=======                ===========");
        Shell.p("help()                 Display usage and help messages. ");
        Shell.p("defineClass(className) Define an extension using the Java class");
        Shell.p("                       named with the string argument. ");
        Shell.p("                       Uses ScriptableObject.defineClass(). ");
        Shell.p("load(['foo.js', ...])  Load JavaScript source files named by ");
        Shell.p("                       string arguments. ");
        Shell.p("loadClass(className)   Load a class named by a string argument.");
        Shell.p("                       The class must be a script compiled to a");
        Shell.p("                       class file. ");
        Shell.p("print([expr ...])      Evaluate and print expressions. ");
        Shell.p("quit()                 Quit the shell. ");
        Shell.p("version([number])      Get or set the JavaScript version number.");
        Shell.p("");
    }

    public static void print(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int i = 0;
        while (i < args.length) {
            if (i > 0) {
                System.out.print(" ");
            }
            String s = Context.toString(args[i]);
            System.out.print(s);
            ++i;
        }
        System.out.println();
    }

    public void quit() {
        this.quitting = true;
    }

    public static double version(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        double result = cx.getLanguageVersion();
        if (args.length > 0) {
            double d = Context.toNumber(args[0]);
            cx.setLanguageVersion((int)d);
        }
        return result;
    }

    public static void load(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        Shell shell = (Shell)Shell.getTopLevelScope(thisObj);
        int i = 0;
        while (i < args.length) {
            shell.processSource(cx, Context.toString(args[i]));
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    private void processSource(Context cx, String filename) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void p(String s) {
        System.out.println(s);
    }
}

