/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class File
extends ScriptableObject {
    private static final long serialVersionUID = 2549960399774237828L;
    private String name;
    private java.io.File file;
    private LineNumberReader reader;
    private BufferedWriter writer;

    public static Scriptable jsConstructor(Context cx, Object[] args, Function ctorObj, boolean inNewExpr) {
        File result = new File();
        if (args.length == 0 || args[0] == Context.getUndefinedValue()) {
            result.name = "";
            result.file = null;
        } else {
            result.name = Context.toString(args[0]);
            result.file = new java.io.File(result.name);
        }
        return result;
    }

    @Override
    public String getClassName() {
        return "File";
    }

    public String jsGet_name() {
        return this.name;
    }

    public Object jsFunction_readLines() throws IOException {
        String s;
        ArrayList<String> list = new ArrayList<String>();
        while ((s = this.jsFunction_readLine()) != null) {
            list.add(s);
        }
        Object[] lines = list.toArray(new String[list.size()]);
        Scriptable scope = ScriptableObject.getTopLevelScope(this);
        Context cx = Context.getCurrentContext();
        return cx.newObject(scope, "Array", lines);
    }

    public String jsFunction_readLine() throws IOException {
        return this.getReader().readLine();
    }

    public String jsFunction_readChar() throws IOException {
        int i = this.getReader().read();
        if (i == -1) {
            return null;
        }
        char[] charArray = new char[]{(char)i};
        return new String(charArray);
    }

    public static void jsFunction_write(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        File.write0(thisObj, args, false);
    }

    public static void jsFunction_writeLine(Context cx, Scriptable thisObj, Object[] args, Function funObj) throws IOException {
        File.write0(thisObj, args, true);
    }

    public int jsGet_lineNumber() throws FileNotFoundException {
        return this.getReader().getLineNumber();
    }

    public void jsFunction_close() throws IOException {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        } else if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    protected void finalize() {
        try {
            this.jsFunction_close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Object jsFunction_getReader() {
        if (this.reader == null) {
            return null;
        }
        Scriptable parent = ScriptableObject.getTopLevelScope(this);
        return Context.javaToJS(this.reader, parent);
    }

    public Object jsFunction_getWriter() {
        if (this.writer == null) {
            return null;
        }
        Scriptable parent = ScriptableObject.getTopLevelScope(this);
        return Context.javaToJS(this.writer, parent);
    }

    private LineNumberReader getReader() throws FileNotFoundException {
        if (this.writer != null) {
            throw Context.reportRuntimeError("already writing file \"" + this.name + "\"");
        }
        if (this.reader == null) {
            this.reader = new LineNumberReader(this.file == null ? new InputStreamReader(System.in) : new FileReader(this.file));
        }
        return this.reader;
    }

    private static void write0(Scriptable thisObj, Object[] args, boolean eol) throws IOException {
        File thisFile = File.checkInstance(thisObj);
        if (thisFile.reader != null) {
            throw Context.reportRuntimeError("already writing file \"" + thisFile.name + "\"");
        }
        if (thisFile.writer == null) {
            thisFile.writer = new BufferedWriter(thisFile.file == null ? new OutputStreamWriter(System.out) : new FileWriter(thisFile.file));
        }
        int i = 0;
        while (i < args.length) {
            String s = Context.toString(args[i]);
            thisFile.writer.write(s, 0, s.length());
            ++i;
        }
        if (eol) {
            thisFile.writer.newLine();
        }
    }

    private static File checkInstance(Scriptable obj) {
        if (obj == null || !(obj instanceof File)) {
            throw Context.reportRuntimeError("called on incompatible object");
        }
        return (File)obj;
    }
}

