/*
 * Decompiled with CFR 0.152.
 */
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class DynamicScopes {
    static boolean useDynamicScope;

    static {
        ContextFactory.initGlobal(new MyFactory());
    }

    public static void main(String[] args) {
        Context cx = Context.enter();
        try {
            String source = "var x = 'sharedScope';\nfunction f() { return x; }\nfunction initClosure(prefix) {\n    return function test() { return prefix+x; }\n}\nvar closure = initClosure('nested:');\n";
            Script script = cx.compileString(source, "sharedScript", 1, null);
            useDynamicScope = false;
            DynamicScopes.runScripts(cx, script);
            useDynamicScope = true;
            DynamicScopes.runScripts(cx, script);
        }
        finally {
            Context.exit();
        }
    }

    static void runScripts(Context cx, Script script) {
        ScriptableObject sharedScope = cx.initStandardObjects(null, true);
        script.exec(cx, sharedScope);
        int threadCount = 3;
        Thread[] t = new Thread[3];
        int i = 0;
        while (i < 3) {
            String source2 = "function g() { var x = 'local'; return f(); }\njava.lang.System.out.println(g());\nfunction g2() { var x = 'local'; return closure(); }\njava.lang.System.out.println(g2());\n";
            t[i] = new Thread(new PerThread(sharedScope, source2, "thread" + i));
            ++i;
        }
        i = 0;
        while (i < 3) {
            t[i].start();
            ++i;
        }
        i = 0;
        while (i < 3) {
            try {
                t[i].join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ++i;
        }
    }

    static class MyFactory
    extends ContextFactory {
        MyFactory() {
        }

        @Override
        protected boolean hasFeature(Context cx, int featureIndex) {
            if (featureIndex == 7) {
                return useDynamicScope;
            }
            return super.hasFeature(cx, featureIndex);
        }
    }

    static class PerThread
    implements Runnable {
        private Scriptable sharedScope;
        private String source;
        private String x;

        PerThread(Scriptable sharedScope, String source, String x) {
            this.sharedScope = sharedScope;
            this.source = source;
            this.x = x;
        }

        @Override
        public void run() {
            Context cx = Context.enter();
            try {
                Scriptable threadScope = cx.newObject(this.sharedScope);
                threadScope.setPrototype(this.sharedScope);
                threadScope.setParentScope(null);
                threadScope.put("x", threadScope, (Object)this.x);
                cx.evaluateString(threadScope, this.source, "threadScript", 1, null);
            }
            finally {
                Context.exit();
            }
        }
    }
}

